/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class LinkSpecTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");
    private static final String REL_VALUE = "foo";
    private static final Uri HREF_VALUE = Uri.parse((String)"http://example.org/foo");

    @Test
    public void parseBasicLink() throws Exception {
        String xml = "<Link rel='foo' href='" + HREF_VALUE + "'/>";
        LinkSpec link = new LinkSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)REL_VALUE, (Object)link.getRel());
        Assert.assertEquals((Object)HREF_VALUE, (Object)link.getHref());
    }

    @Test
    public void parseRelativeLink() throws Exception {
        String xml = "<Link rel='foo' href='/foo'/>";
        LinkSpec link = new LinkSpec(XmlUtil.parse((String)xml), SPEC_URL);
        link = link.substitute(new Substitutions());
        Assert.assertEquals((Object)REL_VALUE, (Object)link.getRel());
        Assert.assertEquals((Object)HREF_VALUE.resolve(Uri.parse((String)"/foo")), (Object)link.getHref());
    }

    @Test
    public void substitutionsPerformed() throws Exception {
        String rel = "foo.bar";
        String href = "jp-DE.xml";
        Uri expectedHref = Uri.parse((String)"http://example.org/jp-DE.xml");
        String xml = "<Link rel='__MSG_rel__' href='http://example.org/__MSG_href__'/>";
        LinkSpec link = new LinkSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Substitutions substitutions = new Substitutions();
        substitutions.addSubstitution(Substitutions.Type.MESSAGE, "rel", rel);
        substitutions.addSubstitution(Substitutions.Type.MESSAGE, "href", href);
        LinkSpec substituted = link.substitute(substitutions);
        Assert.assertEquals((Object)rel, (Object)substituted.getRel());
        Assert.assertEquals((Object)expectedHref, (Object)substituted.getHref());
    }

    @Test(expected=SpecParserException.class)
    public void parseNoRel() throws Exception {
        String xml = "<Link href='foo'/>";
        new LinkSpec(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test(expected=SpecParserException.class)
    public void parseNoHref() throws Exception {
        String xml = "<Link rel='bar'/>";
        new LinkSpec(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test(expected=SpecParserException.class)
    public void parseBogusHref() throws Exception {
        String xml = "<Link rel='foo' href='$%^$#%$#$%'/>";
        new LinkSpec(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test
    public void toStringIsSane() throws Exception {
        String xml = "<Link rel='foo' href='" + HREF_VALUE + "'/>";
        LinkSpec link = new LinkSpec(XmlUtil.parse((String)xml), SPEC_URL);
        LinkSpec link2 = new LinkSpec(XmlUtil.parse((String)link.toString()), SPEC_URL);
        Assert.assertEquals((Object)link.getRel(), (Object)link2.getRel());
        Assert.assertEquals((Object)link.getHref(), (Object)link2.getHref());
        Assert.assertEquals((Object)REL_VALUE, (Object)link2.getRel());
        Assert.assertEquals((Object)HREF_VALUE, (Object)link2.getHref());
    }
}

