/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.oauth.OAuthMessage;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.OAuthUtil;

class OAuthProtocolException
extends Exception {
    private static Set<String> fatalProblems = ImmutableSet.of((Object[])new String[]{"version_rejected", "signature_method_rejected", "consumer_key_unknown", "consumer_key_rejected", "timestamp_refused"});
    private static Set<String> temporaryProblems = ImmutableSet.of((Object)"consumer_key_refused");
    private static Set<String> extensionProblems = ImmutableSet.of((Object)"access_token_expired");
    private final String problemCode;
    private final String problemText;
    private final boolean canRetry;
    private final boolean startFromScratch;
    private final boolean canExtend;

    OAuthProtocolException(boolean canRetry) {
        this.problemCode = null;
        this.problemText = null;
        this.canRetry = canRetry;
        this.startFromScratch = false;
        this.canExtend = false;
    }

    public OAuthProtocolException(OAuthMessage reply) {
        String problem = OAuthUtil.getParameter(reply, "oauth_problem");
        if (problem == null) {
            throw new IllegalArgumentException("No problem reported for OAuthProtocolException");
        }
        this.problemCode = problem;
        this.problemText = OAuthUtil.getParameter(reply, "oauth_problem_advice");
        if (fatalProblems.contains(problem)) {
            this.startFromScratch = true;
            this.canRetry = false;
            this.canExtend = false;
        } else if (temporaryProblems.contains(problem)) {
            this.startFromScratch = false;
            this.canRetry = false;
            this.canExtend = false;
        } else if (extensionProblems.contains(problem)) {
            this.startFromScratch = false;
            this.canRetry = true;
            this.canExtend = true;
        } else {
            this.startFromScratch = true;
            this.canRetry = true;
            this.canExtend = false;
        }
    }

    public OAuthProtocolException(int status) {
        this.problemCode = Integer.toString(status);
        this.problemText = null;
        if (status == 401) {
            this.startFromScratch = true;
            this.canRetry = true;
        } else {
            this.startFromScratch = true;
            this.canRetry = false;
        }
        this.canExtend = false;
    }

    public boolean startFromScratch() {
        return this.startFromScratch;
    }

    public boolean canRetry() {
        return this.canRetry;
    }

    public boolean canExtend() {
        return this.canExtend;
    }

    public HttpResponse getResponseForGadget() {
        return new HttpResponseBuilder().setHttpStatusCode(0).setMetadata("oauthError", this.problemCode).setMetadata("oauthErrorText", this.problemText).create();
    }
}

