/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthUtil {
    public static String getParameter(OAuthMessage message, String name) {
        try {
            return message.getParameter(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map.Entry<String, String>> getParameters(OAuthMessage message) {
        try {
            return message.getParameters();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void requireParameters(OAuthMessage message, String ... names) throws OAuthProblemException {
        try {
            message.requireParameters(names);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formEncode(Iterable<? extends Map.Entry<String, String>> parameters) {
        try {
            return OAuth.formEncode(parameters);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String addParameters(String url, List<Map.Entry<String, String>> parameters) {
        try {
            return OAuth.addParameters((String)url, parameters);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OAuthMessage newRequestMessage(OAuthAccessor accessor, String method, String url, List<OAuth.Parameter> parameters) throws OAuthException {
        try {
            return accessor.newRequestMessage(method, url, parameters);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

