/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBundle {
    public static final MessageBundle EMPTY = new MessageBundle();
    private final Map<String, String> messages;
    private final String languageDirection;
    private final String jsonString;

    public MessageBundle(LocaleSpec locale, String xml) throws SpecParserException {
        Element doc;
        try {
            doc = XmlUtil.parse((String)xml);
        }
        catch (XmlException e) {
            throw new SpecParserException("Malformed XML in file " + locale.getMessages() + ": " + e.getMessage());
        }
        this.messages = this.parseMessages(doc);
        this.jsonString = new JSONObject(this.messages).toString();
        this.languageDirection = locale.getLanguageDirection();
    }

    public MessageBundle(Element element) throws SpecParserException {
        this.messages = this.parseMessages(element);
        this.jsonString = new JSONObject(this.messages).toString();
        this.languageDirection = XmlUtil.getAttribute((Node)element, (String)"language_direction", (String)"ltr");
    }

    public MessageBundle(MessageBundle parent, MessageBundle child) {
        HashMap merged = Maps.newHashMap();
        String dir = null;
        if (parent != null) {
            merged.putAll(parent.messages);
            dir = parent.languageDirection;
        }
        if (child != null) {
            merged.putAll(child.messages);
            dir = child.languageDirection;
        }
        this.messages = Collections.unmodifiableMap(merged);
        this.jsonString = new JSONObject(this.messages).toString();
        this.languageDirection = dir;
    }

    private MessageBundle() {
        this.messages = Collections.emptyMap();
        this.jsonString = "{}";
        this.languageDirection = "ltr";
    }

    public String getLanguageDirection() {
        return this.languageDirection;
    }

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public String toJSONString() {
        return this.jsonString;
    }

    private Map<String, String> parseMessages(Element element) throws SpecParserException {
        NodeList nodes = element.getElementsByTagName("msg");
        ImmutableMap.Builder messages = ImmutableMap.builder();
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            Element msg = (Element)nodes.item(i);
            String name = XmlUtil.getAttribute((Node)msg, (String)"name");
            if (name == null) {
                throw new SpecParserException("All message bundle entries must have a name attribute.");
            }
            messages.put((Object)name, (Object)msg.getTextContent().trim());
        }
        return messages.build();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<messagebundle>\n");
        for (Map.Entry<String, String> entry : this.messages.entrySet()) {
            buf.append("<msg name=\"").append(entry.getKey()).append("\">").append(entry.getValue()).append("</msg>\n");
        }
        buf.append("</messagebundle>");
        return buf.toString();
    }
}

