/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.AbstractSpecFactory;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultGadgetSpecFactory
extends AbstractSpecFactory<GadgetSpec>
implements GadgetSpecFactory {
    public static final String CACHE_NAME = "gadgetSpecs";
    static final String RAW_GADGETSPEC_XML_PARAM_NAME = "rawxml";
    static final Uri RAW_GADGET_URI = Uri.parse((String)"http://localhost/raw.xml");

    @Inject
    public DefaultGadgetSpecFactory(ExecutorService executor, RequestPipeline pipeline, CacheProvider cacheProvider, @Named(value="shindig.cache.xml.refreshInterval") long refresh) {
        super(GadgetSpec.class, executor, pipeline, DefaultGadgetSpecFactory.makeCache(cacheProvider), refresh);
    }

    private static Cache<Uri, Object> makeCache(CacheProvider cacheProvider) {
        return cacheProvider.createCache(CACHE_NAME);
    }

    @Override
    public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
        String rawxml = context.getParameter(RAW_GADGETSPEC_XML_PARAM_NAME);
        if (rawxml != null) {
            try {
                return new GadgetSpec(RAW_GADGET_URI, XmlUtil.parse((String)rawxml), rawxml);
            }
            catch (XmlException e) {
                throw new SpecParserException(e);
            }
        }
        Uri gadgetUri = context.getUrl();
        AbstractSpecFactory.Query query = new AbstractSpecFactory.Query().setSpecUri(gadgetUri).setContainer(context.getContainer()).setGadgetUri(gadgetUri).setIgnoreCache(context.getIgnoreCache());
        return (GadgetSpec)super.getSpec(query);
    }

    @Override
    protected GadgetSpec parse(String content, AbstractSpecFactory.Query query) throws XmlException, GadgetException {
        Element element = XmlUtil.parse((String)content);
        return new GadgetSpec(query.getSpecUri(), element, content);
    }
}

