/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;
import org.apache.shindig.gadgets.config.ConfigContributor;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.spec.Feature;

@Singleton
public class CoreUtilConfigContributor
implements ConfigContributor {
    private final FeatureRegistry registry;
    private final GadgetAdminStore gadgetAdminStore;

    @Inject
    public CoreUtilConfigContributor(FeatureRegistry registry, GadgetAdminStore gadgetAdminStore) {
        this.registry = registry;
        this.gadgetAdminStore = gadgetAdminStore;
    }

    @Override
    public void contribute(Map<String, Object> config, Gadget gadget) {
        Collection<Feature> features = gadget.getViewFeatures().values();
        HashMap featureMap = Maps.newHashMapWithExpectedSize((int)features.size());
        Set<String> allFeatureNames = this.registry.getAllFeatureNames();
        for (Feature feature : features) {
            if (!allFeatureNames.contains(feature.getName()) || !this.gadgetAdminStore.isAllowedFeature(feature, gadget)) continue;
            HashMap paramFeaturesInConfig = Maps.newHashMap();
            for (String paramName : feature.getParams().keySet()) {
                Collection paramValues = feature.getParams().get((Object)paramName);
                if ("opensocial-templates".equals(feature.getName()) && "requireLibrary".equals(paramName)) {
                    if (paramValues.size() == 1) {
                        Uri paramUri = Uri.parse((String)((String)paramValues.iterator().next()).trim());
                        paramUri = gadget.getContext().getUrl().resolve(paramUri);
                        paramFeaturesInConfig.put(paramName, paramUri.toString());
                        continue;
                    }
                    ArrayList abReqLibs = Lists.newArrayList();
                    for (String libraryUrl : paramValues) {
                        Uri paramUri = Uri.parse((String)libraryUrl.trim());
                        paramUri = gadget.getContext().getUrl().resolve(paramUri);
                        abReqLibs.add(paramUri.toString());
                    }
                    paramFeaturesInConfig.put(paramName, abReqLibs);
                    continue;
                }
                if (paramValues.size() == 1) {
                    paramFeaturesInConfig.put(paramName, paramValues.iterator().next());
                    continue;
                }
                paramFeaturesInConfig.put(paramName, paramValues);
            }
            featureMap.put(feature.getName(), paramFeaturesInConfig);
        }
        config.put("core.util", featureMap);
    }

    @Override
    public void contribute(Map<String, Object> config, String container, String host) {
    }
}

