/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public interface FeatureResource {
    public String getContent();

    public String getDebugContent();

    public boolean isExternal();

    public boolean isProxyCacheable();

    public String getName();

    public Map<String, String> getAttribs();

    public static class Simple
    extends Default {
        private final String content;
        private final String debugContent;
        private final String name;

        public Simple(String content, String debugContent, String name) {
            this.content = content;
            this.debugContent = debugContent;
            this.name = name;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getDebugContent() {
            return this.debugContent;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static abstract class Attribute
    extends Default {
        private final Map<String, String> attribs;

        public Attribute(Map<String, String> attribs) {
            this.attribs = attribs;
        }

        @Override
        public Map<String, String> getAttribs() {
            return this.attribs;
        }
    }

    public static abstract class Default
    implements FeatureResource {
        @Override
        public boolean isExternal() {
            return false;
        }

        @Override
        public boolean isProxyCacheable() {
            return true;
        }

        @Override
        public Map<String, String> getAttribs() {
            return ImmutableMap.of();
        }
    }
}

