/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.HttpResponseMetadataHelper;
import org.apache.shindig.gadgets.http.InvalidationService;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.oauth2.OAuth2Request;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;

@Singleton
public class DefaultRequestPipeline
implements RequestPipeline {
    private final HttpFetcher httpFetcher;
    private final HttpCache httpCache;
    private final Provider<OAuthRequest> oauthRequestProvider;
    private final Provider<OAuth2Request> oauth2RequestProvider;
    private final ResponseRewriterRegistry responseRewriterRegistry;
    private final InvalidationService invalidationService;
    private final HttpResponseMetadataHelper metadataHelper;
    static final long DEFAULT_DRIFT_LIMIT_MS = 180000L;
    @Inject(optional=true)
    @Named(value="shindig.http.date-drift-limit-ms")
    private static long responseDateDriftLimit = 180000L;
    private static final String classname = DefaultRequestPipeline.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    @Inject
    public DefaultRequestPipeline(HttpFetcher httpFetcher, HttpCache httpCache, Provider<OAuthRequest> oauthRequestProvider, Provider<OAuth2Request> oauth2RequestProvider, @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.REQUEST_PIPELINE) ResponseRewriterRegistry responseRewriterRegistry, InvalidationService invalidationService, @Nullable HttpResponseMetadataHelper metadataHelper) {
        this.httpFetcher = httpFetcher;
        this.httpCache = httpCache;
        this.oauthRequestProvider = oauthRequestProvider;
        this.oauth2RequestProvider = oauth2RequestProvider;
        this.responseRewriterRegistry = responseRewriterRegistry;
        this.invalidationService = invalidationService;
        this.metadataHelper = metadataHelper;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws GadgetException {
        String method = "execute";
        this.normalizeProtocol(request);
        HttpResponse cachedResponse = this.checkCachedResponse(request);
        HttpResponse invalidatedResponse = null;
        HttpResponse staleResponse = null;
        if (cachedResponse != null && !cachedResponse.isStrictNoCache()) {
            if (!cachedResponse.isStale()) {
                if (this.invalidationService.isValid(request, cachedResponse)) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.logp(Level.FINEST, classname, "execute", "cachedResponse", new Object[]{request.getUri().toString()});
                    }
                    return cachedResponse;
                }
                invalidatedResponse = cachedResponse;
            } else if (!cachedResponse.isError()) {
                staleResponse = cachedResponse;
            }
        }
        if (staleResponse != null) {
            String etag;
            String lastModified = staleResponse.getHeader("Last-Modified");
            if (lastModified != null) {
                request.setHeader("If-Modified-Since", lastModified);
            }
            if ((etag = staleResponse.getHeader("ETag")) != null) {
                request.setHeader("If-None-Match", etag);
            }
        }
        HttpResponse fetchedResponse = this.fetchResponse(request);
        fetchedResponse = this.fixFetchedResponse(request, fetchedResponse, invalidatedResponse, staleResponse);
        return fetchedResponse;
    }

    protected void normalizeProtocol(HttpRequest request) throws GadgetException {
        if (request.getUri().getScheme() == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Url " + request.getUri().toString() + " does not include scheme", 400);
        }
        if (!"http".equals(request.getUri().getScheme()) && !"https".equals(request.getUri().getScheme())) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid request url scheme in url: " + Utf8UrlCoder.encode((String)request.getUri().toString()) + "; only \"http\" and \"https\" supported.", 400);
        }
    }

    protected HttpResponse checkCachedResponse(HttpRequest request) {
        HttpResponse cachedResponse = !request.getIgnoreCache() ? this.httpCache.getResponse(request) : null;
        return cachedResponse;
    }

    protected HttpResponse fetchResponse(HttpRequest request) throws GadgetException {
        HttpResponse fetchedResponse;
        switch (request.getAuthType()) {
            case NONE: {
                fetchedResponse = this.httpFetcher.fetch(request);
                break;
            }
            case SIGNED: 
            case OAUTH: {
                fetchedResponse = ((OAuthRequest)this.oauthRequestProvider.get()).fetch(request);
                break;
            }
            case OAUTH2: {
                fetchedResponse = ((OAuth2Request)this.oauth2RequestProvider.get()).fetch(request);
                break;
            }
            default: {
                return HttpResponse.error();
            }
        }
        return fetchedResponse;
    }

    protected HttpResponse fixFetchedResponse(HttpRequest request, HttpResponse fetchedResponse, @Nullable HttpResponse invalidatedResponse, @Nullable HttpResponse staleResponse) throws GadgetException {
        String method = "fixFetchedResponse";
        if (fetchedResponse.isError() && invalidatedResponse != null) {
            return invalidatedResponse;
        }
        if (fetchedResponse.getHttpStatusCode() >= 500 && staleResponse != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.logp(Level.FINEST, classname, "fixFetchedResponse", "staleResponse", new Object[]{request.getUri().toString()});
            }
            return staleResponse;
        }
        if ((fetchedResponse = DefaultRequestPipeline.maybeFixDriftTime(fetchedResponse)).getHttpStatusCode() == 304) {
            Multimap<String, String> fetchedResponseHeaders = fetchedResponse.getHeaders();
            if (fetchedResponse.getCacheControlMaxAge() == -1L && fetchedResponse.getExpiresTime() == -1L) {
                return this.httpCache.removeResponse(request);
            }
            HttpResponseBuilder httpResponseBuilder = new HttpResponseBuilder(staleResponse);
            for (String headerName : fetchedResponseHeaders.keySet()) {
                httpResponseBuilder.removeHeader(headerName);
            }
            httpResponseBuilder.addAllHeaders(fetchedResponse.getHeaders());
            return this.cacheFetchedResponse(request, httpResponseBuilder.create());
        }
        if (!fetchedResponse.isError() && !request.getIgnoreCache() && request.getCacheTtl() != 0) {
            try {
                fetchedResponse = this.responseRewriterRegistry.rewriteHttpResponse(request, fetchedResponse, null);
            }
            catch (RewritingException e) {
                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, e.getHttpStatusCode());
            }
        }
        fetchedResponse = HttpResponseMetadataHelper.updateHash(fetchedResponse, this.metadataHelper);
        fetchedResponse = this.cacheFetchedResponse(request, fetchedResponse);
        return fetchedResponse;
    }

    protected HttpResponse cacheFetchedResponse(HttpRequest request, HttpResponse fetchedResponse) {
        if (!request.getIgnoreCache()) {
            HttpResponse cached;
            if (fetchedResponse.getCacheTtl() > 0L) {
                fetchedResponse = this.invalidationService.markResponse(request, fetchedResponse);
            }
            if ((cached = this.httpCache.addResponse(request, fetchedResponse)) != null) {
                fetchedResponse = cached;
            }
        }
        return fetchedResponse;
    }

    public static HttpResponse maybeFixDriftTime(HttpResponse response) {
        Date d;
        Collection<String> dates = response.getHeaders("Date");
        if (!dates.isEmpty() && (d = DateUtil.parseRfc1123Date((String)dates.iterator().next())) != null) {
            long timestamp = d.getTime();
            long currentTime = HttpUtil.getTimeSource().currentTimeMillis();
            if (Math.abs(currentTime - timestamp) > responseDateDriftLimit) {
                HttpResponseBuilder builder = new HttpResponseBuilder(response);
                builder.setHeader("Date", DateUtil.formatRfc1123Date((long)currentTime));
                response = builder.create();
            }
        }
        return response;
    }
}

