/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.js.BaseSurfaceJsProcessor;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class DeferJsProcessor
extends BaseSurfaceJsProcessor
implements JsProcessor {
    @VisibleForTesting
    static final String FEATURE_NAME = "deferjs";
    private static final String FUNCTION_NAME = "deferJs";

    @Inject
    public DeferJsProcessor(FeatureRegistryProvider featureRegistryProvider, Provider<GadgetContext> context) {
        super(featureRegistryProvider, context);
    }

    @Override
    public boolean process(JsRequest jsRequest, JsResponseBuilder builder) throws JsException {
        JsUriManager.JsUri jsUri = jsRequest.getJsUri();
        ImmutableList.Builder resp = ImmutableList.builder();
        FeatureRegistry featureRegistry = this.getFeatureRegistry(jsUri);
        boolean needDefers = false;
        if (jsUri.isJsload()) {
            List<FeatureRegistry.FeatureBundle> bundles = this.getSupportDeferBundles(featureRegistry, jsRequest);
            for (FeatureRegistry.FeatureBundle bundle : bundles) {
                needDefers |= this.appendDeferJsStatements((ImmutableList.Builder<JsContent>)resp, jsRequest.getJsUri(), bundle);
            }
        }
        if (needDefers) {
            builder.appendAllJs(this.getSurfaceJsContents(featureRegistry, FEATURE_NAME));
        }
        builder.appendAllJs((Iterable<JsContent>)resp.build());
        return true;
    }

    private boolean appendDeferJsStatements(ImmutableList.Builder<JsContent> builder, JsUriManager.JsUri jsUri, FeatureRegistry.FeatureBundle bundle) {
        List<String> exports = this.getExports(bundle, jsUri);
        if (!exports.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (BaseSurfaceJsProcessor.Input input : this.generateInputs(exports)) {
                sb.append(this.toDeferStatement(input));
            }
            builder.add((Object)JsContent.fromFeature(sb.toString(), "[generated-symbol-exports]", bundle, null));
            return true;
        }
        return false;
    }

    private String toDeferStatement(BaseSurfaceJsProcessor.Input input) {
        StringBuilder result = new StringBuilder();
        if (input.namespace != null) {
            result.append(FUNCTION_NAME).append("('").append(input.namespace).append("',[");
            for (int i = 0; i < input.properties.size(); ++i) {
                String prop = input.properties.get(i);
                if (i > 0) {
                    result.append(',');
                }
                result.append('\'').append(prop).append('\'');
            }
            result.append("]);");
        } else {
            for (String prop : input.properties) {
                result.append(FUNCTION_NAME).append("('").append(prop).append("');");
            }
        }
        return result.toString();
    }

    private List<FeatureRegistry.FeatureBundle> getSupportDeferBundles(FeatureRegistry registry, JsRequest jsRequest) {
        ArrayList result = Lists.newArrayList();
        FeatureRegistry.LookupResult lookup = registry.getFeatureResources((GadgetContext)this.context.get(), jsRequest.getNewFeatures(), null, false);
        for (FeatureRegistry.FeatureBundle bundle : lookup.getBundles()) {
            if (!bundle.isSupportDefer()) continue;
            result.add(bundle);
        }
        return result;
    }
}

