/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.persistence.sample;

public class OAuth2GadgetBinding {
    private final boolean allowOverride;
    private final String clientName;
    private final String gadgetServiceName;
    private final String gadgetUri;

    public OAuth2GadgetBinding(String gadgetUri, String gadgetServiceName, String clientName, boolean allowOverride) {
        this.gadgetUri = gadgetUri;
        this.gadgetServiceName = gadgetServiceName;
        this.clientName = clientName;
        this.allowOverride = allowOverride;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OAuth2GadgetBinding)) {
            return false;
        }
        OAuth2GadgetBinding other = (OAuth2GadgetBinding)obj;
        if (this.gadgetUri == null ? other.gadgetUri != null : !this.gadgetUri.equals(other.gadgetUri)) {
            return false;
        }
        return !(this.gadgetServiceName == null ? other.gadgetServiceName != null : !this.gadgetServiceName.equals(other.gadgetServiceName));
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getGadgetServiceName() {
        return this.gadgetServiceName;
    }

    public String getGadgetUri() {
        return this.gadgetUri;
    }

    public int hashCode() {
        if (this.gadgetUri != null && this.gadgetServiceName != null) {
            return (this.gadgetUri + ':' + this.gadgetServiceName).hashCode();
        }
        return 0;
    }

    public boolean isAllowOverride() {
        return this.allowOverride;
    }

    public String toString() {
        return "org.apache.shindig.gadgets.oauth2.persistence.sample.OAuth2GadgetBinding: gadgetUri = " + this.gadgetUri + " , gadgetServiceName = " + this.gadgetServiceName + " , allowOverride = " + this.allowOverride;
    }
}

