/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementELResolver
extends ELResolver {
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof ElementWrapper) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        Object value = this.getValue(context, base, property);
        return value == null ? null : value.getClass();
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (!(base instanceof ElementWrapper)) {
            return null;
        }
        context.setPropertyResolved(true);
        Element element = ((ElementWrapper)base).element;
        String propertyString = property.toString();
        Object data = element.getUserData(propertyString);
        if (data != null) {
            return data;
        }
        Attr attribute = element.getAttributeNode(propertyString);
        if (attribute != null) {
            return attribute.getValue();
        }
        List childElements = null;
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (!(child instanceof Element) || !propertyString.equals((childElement = (Element)child).getLocalName())) continue;
            if (childElements == null) {
                childElements = Lists.newArrayListWithCapacity((int)2);
            }
            childElements.add(new ElementWrapper(childElement));
        }
        if (childElements == null) {
            return null;
        }
        if (childElements.size() == 1) {
            return childElements.get(0);
        }
        return childElements;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof ElementWrapper) {
            context.setPropertyResolved(true);
        }
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    public static class ElementWrapper {
        public final Element element;

        public ElementWrapper(Element element) {
            this.element = element;
        }

        public String toString() {
            return this.element.getTextContent();
        }
    }
}

