/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetELResolver;
import org.apache.shindig.gadgets.UserPrefs;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GadgetELResolverTest {
    private UserPrefs userPrefs;
    private String viewParams;
    private ELResolver resolver;
    private Expressions expressions;
    private ELContext context;

    @Before
    public void setUp() throws Exception {
        GadgetContext gadgetContext = new GadgetContext(){

            public String getParameter(String name) {
                if ("view-params".equals(name)) {
                    return GadgetELResolverTest.this.viewParams;
                }
                return null;
            }

            public UserPrefs getUserPrefs() {
                return GadgetELResolverTest.this.userPrefs;
            }
        };
        this.resolver = new GadgetELResolver(gadgetContext);
        this.expressions = Expressions.forTesting();
        this.context = this.expressions.newELContext(new ELResolver[]{this.resolver});
    }

    @Test
    public void getPrefs() {
        this.userPrefs = new UserPrefs((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        ValueExpression expression = this.expressions.parse("${UserPrefs.foo}", String.class);
        Assert.assertEquals((Object)"bar", (Object)expression.getValue(this.context));
        expression = this.expressions.parse("${UserPrefs.wrongKey}", String.class);
        Assert.assertEquals((Object)"", (Object)expression.getValue(this.context));
    }

    @Test
    public void getPrefsEmpty() {
        this.userPrefs = UserPrefs.EMPTY;
        ValueExpression expression = this.expressions.parse("${UserPrefs.foo}", String.class);
        Assert.assertEquals((Object)"", (Object)expression.getValue(this.context));
    }

    @Test
    public void testViewParams() {
        this.viewParams = "{foo: 'bar'}";
        ValueExpression expression = this.expressions.parse("${ViewParams.foo}", String.class);
        Assert.assertEquals((Object)"bar", (Object)expression.getValue(this.context));
        expression = this.expressions.parse("${ViewParams.wrongKey}", String.class);
        Assert.assertEquals((Object)"", (Object)expression.getValue(this.context));
    }

    @Test
    public void testViewParamsEmpty() {
        ValueExpression expression = this.expressions.parse("${ViewParams.foo}", String.class);
        Assert.assertEquals((Object)"", (Object)expression.getValue(this.context));
    }
}

