/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.SocialMarkupHtmlParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialMarkupHtmlParserTest {
    private SocialMarkupHtmlParser parser;
    private Document document;

    @Before
    public void setUp() throws Exception {
        this.parser = new SocialMarkupHtmlParser(new ParseModule.DOMImplementationProvider().get());
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test-socialmarkup.html"));
        this.document = this.parser.parseDom(content);
    }

    @Test
    public void testSocialData() {
        List<Element> scripts = this.getScripts("text/os-data");
        Assert.assertEquals((long)1L, (long)scripts.size());
        NodeList viewerRequests = scripts.get(0).getElementsByTagNameNS("http://ns.opensocial.org/2008/markup", "ViewerRequest");
        Assert.assertEquals((long)1L, (long)viewerRequests.getLength());
        Element viewerRequest = (Element)viewerRequests.item(0);
        Assert.assertEquals((Object)"viewer", (Object)viewerRequest.getAttribute("key"));
        Assert.assertNull((Object)viewerRequest.getFirstChild());
    }

    @Test
    public void testSocialTemplate() {
        List<Element> scripts = this.getScripts("text/os-template");
        Assert.assertEquals((long)1L, (long)scripts.size());
        NodeList boldElements = scripts.get(0).getElementsByTagName("b");
        Assert.assertEquals((long)1L, (long)boldElements.getLength());
        Element boldElement = (Element)boldElements.item(0);
        Assert.assertEquals((Object)"Some ${viewer} content", (Object)boldElement.getTextContent());
        NodeList osHtmlElements = scripts.get(0).getElementsByTagNameNS("http://ns.opensocial.org/2008/markup", "Html");
        Assert.assertEquals((long)1L, (long)osHtmlElements.getLength());
    }

    @Test
    public void testSocialTemplateSerialization() {
        String content = HtmlSerialization.serialize((Document)this.document);
        Assert.assertTrue((String)"Empty elements not preserved as XML inside template", (boolean)content.contains("<img/>"));
    }

    @Test
    public void testJavascript() {
        List<Element> scripts = this.getScripts("text/javascript");
        Assert.assertEquals((long)1L, (long)scripts.size());
        NodeList boldElements = scripts.get(0).getElementsByTagName("b");
        Assert.assertEquals((long)0L, (long)boldElements.getLength());
        String scriptContent = scripts.get(0).getTextContent().trim();
        Assert.assertEquals((Object)"<b>Some ${viewer} content</b>", (Object)scriptContent);
    }

    @Test
    public void testPlainContent() {
        NodeList spanElements = this.document.getElementsByTagName("span");
        Assert.assertEquals((long)1L, (long)spanElements.getLength());
        Assert.assertEquals((Object)"Some content", (Object)spanElements.item(0).getTextContent());
    }

    @Test
    public void testCommentOrdering() {
        NodeList divElements = this.document.getElementsByTagName("div");
        Assert.assertEquals((long)1L, (long)divElements.getLength());
        NodeList children = divElements.item(0).getChildNodes();
        Assert.assertEquals((long)3L, (long)children.getLength());
        Assert.assertEquals((long)8L, (long)children.item(0).getNodeType());
        Assert.assertEquals((long)3L, (long)children.item(1).getNodeType());
        Assert.assertEquals((long)8L, (long)children.item(2).getNodeType());
    }

    @Test
    public void testInvalid() throws Exception {
        String content = "<html><div id=\"div_super\" class=\"div_super\" valign:\"middle\"></div></html>";
        try {
            this.parser.parseDom(content);
            Assert.assertTrue((String)"No exception caught", (boolean)false);
        }
        catch (DOMException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("INVALID_CHARACTER_ERR"));
            Assert.assertTrue((boolean)e.getMessage().contains("Around ...<div id=\"div_super\" class=\"div_super\"..."));
        }
    }

    private List<Element> getScripts(final String type) {
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)this.document)).createNodeIterator(this.document, 1, new NodeFilter(){

            public short acceptNode(Node n) {
                if ("script".equalsIgnoreCase(n.getNodeName()) && type.equals(((Element)n).getAttribute("type"))) {
                    return 1;
                }
                return 2;
            }
        }, false);
        ArrayList scripts = Lists.newArrayList();
        Node n = nodeIterator.nextNode();
        while (n != null) {
            scripts.add((Element)n);
            n = nodeIterator.nextNode();
        }
        return scripts;
    }
}

