/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.JsonContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.Functions;
import org.apache.shindig.expressions.ShindigTypeConverter;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.render.DefaultServiceFetcher;
import org.easymock.classextension.EasyMock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultServiceFetcherTest
extends EasyMockTestCase {
    protected DefaultServiceFetcher fetcher;
    protected HttpFetcher mockFetcher;
    protected Multimap<String, String> configuredServices;
    protected static final String endPoint1 = "http://%host%/api/rpc";
    protected static final String endPoint2 = "http://%host%/social/api/rpc";

    protected void setUp() throws Exception {
        super.setUp();
        JSONObject config = this.createConfig();
        JsonContainerConfig containerConfig = new JsonContainerConfig(config, new Expressions(new Functions(new Class[0]), null, new ShindigTypeConverter()));
        this.mockFetcher = (HttpFetcher)this.mock(HttpFetcher.class);
        this.fetcher = new DefaultServiceFetcher((ContainerConfig)containerConfig, this.mockFetcher);
    }

    private JSONObject createConfig() throws JSONException {
        JSONObject config = new JSONObject();
        JSONObject container = new JSONObject();
        JSONObject services = new JSONObject();
        JSONObject features = new JSONObject();
        this.configuredServices = ImmutableMultimap.builder().putAll((Object)"http://localhost/api/rpc", (Object[])new String[]{"system.listMethods", "service.get"}).putAll((Object)"gadgets.rpc", (Object[])new String[]{"messages.send", "ui.resize"}).build();
        for (String key : this.configuredServices.keySet()) {
            services.put(key, this.configuredServices.get((Object)key));
        }
        features.put("osapi.services", (Object)services);
        JSONObject endpoints = new JSONObject();
        endpoints.put("endPoints", (Object)new JSONArray((Collection)ImmutableList.of((Object)endPoint1, (Object)endPoint2)));
        features.put("osapi", (Object)endpoints);
        container.put("gadgets.features", (Object)features);
        config.put("default", (Object)container);
        return config;
    }

    public void testReadConfigNoEndpoints() throws Exception {
        JSONObject config = this.createConfig();
        config.getJSONObject("default").getJSONObject("gadgets.features").remove("osapi");
        JsonContainerConfig containerConfig = new JsonContainerConfig(config, new Expressions(new Functions(new Class[0]), null, new ShindigTypeConverter()));
        this.fetcher = new DefaultServiceFetcher((ContainerConfig)containerConfig, this.mockFetcher);
        EasyMock.expect((Object)this.mockFetcher.fetch((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)new HttpResponse("")).anyTimes();
        this.replay();
        Multimap services = this.fetcher.getServicesForContainer("default", "dontcare");
        this.verify();
        DefaultServiceFetcherTest.assertEquals(this.configuredServices, (Object)services);
    }

    public void testReadConfigEndpointsDown() throws Exception {
        EasyMock.expect((Object)this.mockFetcher.fetch((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)new HttpResponse("")).anyTimes();
        this.replay();
        Multimap services = this.fetcher.getServicesForContainer("default", "dontcare");
        this.verify();
        DefaultServiceFetcherTest.assertEquals(this.configuredServices, (Object)services);
    }

    public void testReadConfigWithValidEndpoints() throws Exception {
        ImmutableList endPoint1Services = ImmutableList.of((Object)"do.something", (Object)"delete.someting");
        JSONObject service1 = new JSONObject();
        service1.put("data", (Collection)endPoint1Services);
        ImmutableList endPoint2Services = ImmutableList.of((Object)"weather.get");
        JSONObject service2 = new JSONObject();
        service2.put("data", (Collection)endPoint2Services);
        EasyMock.expect((Object)this.mockFetcher.fetch((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)new HttpResponse(service1.toString()));
        EasyMock.expect((Object)this.mockFetcher.fetch((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)new HttpResponse(service2.toString()));
        this.replay();
        Multimap services = this.fetcher.getServicesForContainer("default", "dontcare");
        this.verify();
        LinkedHashMultimap mergedServices = LinkedHashMultimap.create(this.configuredServices);
        mergedServices.putAll((Object)endPoint1, (Iterable)endPoint1Services);
        mergedServices.putAll((Object)endPoint2, (Iterable)endPoint2Services);
        DefaultServiceFetcherTest.assertEquals((Object)mergedServices, (Object)LinkedHashMultimap.create((Multimap)services));
    }

    public void testReadConfigBadContainer() throws Exception {
        Multimap multimap = this.fetcher.getServicesForContainer("badcontainer", "dontcare");
        DefaultServiceFetcherTest.assertEquals((int)0, (int)multimap.size());
    }
}

