/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.image.BMPOptimizer;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizerTest;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.junit.Ignore;

public class BMPOptimizerTest
extends BaseOptimizerTest {
    Logger log = Logger.getLogger(BMPOptimizerTest.class.getName());

    public void testSimpleImage() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/simple.bmp", "image/bmp");
        HttpResponse rewritten = this.rewrite(resp);
        BMPOptimizerTest.assertTrue((rewritten.getContentLength() < resp.getContentLength() ? 1 : 0) != 0);
        BMPOptimizerTest.assertEquals((String)rewritten.getHeader("Content-Type"), (String)"image/png");
    }

    @Ignore(value="Kills some VMs")
    public void testEvilImages() throws Exception {
        try {
            HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/evil.bmp", "image/bmp");
            this.rewrite(resp);
            BMPOptimizerTest.fail((String)"Evil image should not be readable");
        }
        catch (RuntimeException re) {
            this.log.log(Level.INFO, "Good failure while reading evil image", re);
        }
    }

    public void testEvilImage2() throws Exception {
        try {
            HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/evil2.bmp", "image/bmp");
            this.rewrite(resp);
            BMPOptimizerTest.fail((String)"Evil image should not be readable");
        }
        catch (RuntimeException re) {
            this.log.log(Level.INFO, "Good failure while reading evil image", re);
        }
    }

    protected HttpResponse rewrite(HttpResponse original) throws IOException, ImageReadException {
        return new BMPOptimizer(new OptimizerConfig(), original).rewrite(Sanselan.getBufferedImage((InputStream)original.getResponse()));
    }
}

