/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizerTest;
import org.apache.shindig.gadgets.rewrite.image.JPEGOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;

public class JPEGOptimizerTest
extends BaseOptimizerTest {
    public void testSmallJPEGToPNG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/small.jpg", "image/jpeg");
        HttpResponse rewritten = this.rewrite(resp);
        JPEGOptimizerTest.assertEquals((String)rewritten.getHeader("Content-Type"), (String)"image/png");
        JPEGOptimizerTest.assertTrue((rewritten.getContentLength() * 100 / resp.getContentLength() < 70 ? 1 : 0) != 0);
    }

    public void testLargeJPEG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/large.jpg", "image/jpeg");
        HttpResponse rewritten = this.rewrite(resp);
        JPEGOptimizerTest.assertEquals((String)resp.getHeader("Content-Type"), (String)"image/jpeg");
        JPEGOptimizerTest.assertTrue((rewritten.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
    }

    public void testBadImage() throws Exception {
        try {
            HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/bad.jpg", "image/jpeg");
            this.rewrite(resp);
            JPEGOptimizerTest.fail((String)"Should fail to read an invalid JPEG");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void xtestBadICC1() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc.jpg", "image/jpeg");
        this.rewrite(resp);
    }

    public void testBadICC2() throws Exception {
        try {
            HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc2.jpg", "image/jpeg");
            this.rewrite(resp);
            JPEGOptimizerTest.fail((String)"Should error with invalid ICC data");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testBadICC3() throws Exception {
        try {
            HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc3.jpg", "image/jpeg");
            this.rewrite(resp);
            JPEGOptimizerTest.fail((String)"Should error with invalid ICC data");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testBadICC4() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc4.jpg", "image/jpeg");
        try {
            this.rewrite(resp);
            JPEGOptimizerTest.fail((String)"Should have failed with OutOfMemory exception");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void testBadICC5() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/2ndjpgbad.jpg", "image/jpeg");
        this.rewrite(resp);
    }

    HttpResponse rewrite(HttpResponse original) throws IOException, ImageReadException {
        return new JPEGOptimizer(new OptimizerConfig(), original).rewrite(JPEGOptimizer.readJpeg((InputStream)original.getResponse()));
    }
}

