/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableMap;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.SocialMarkupHtmlParser;
import org.apache.shindig.gadgets.templates.FakeTemplateProcessor;
import org.apache.shindig.gadgets.templates.HtmlTagHandler;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlTagHandlerTest {
    private FakeTemplateProcessor processor;
    private DOMImplementation documentProvider;
    private HtmlTagHandler handler;

    @Before
    public void setUp() throws Exception {
        this.processor = new FakeTemplateProcessor();
        this.documentProvider = new ParseModule.DOMImplementationProvider().get();
        this.handler = new HtmlTagHandler((GadgetHtmlParser)new SocialMarkupHtmlParser(this.documentProvider));
    }

    @Test
    public void testHtmlTag() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("test");
        tag.setAttribute("code", "${code}");
        this.processor.expressionResults = ImmutableMap.of((Object)"${code}", (Object)"Hello <b>World</b>!");
        DocumentFragment fragment = doc.createDocumentFragment();
        this.handler.process((Node)fragment, tag, (TemplateProcessor)this.processor);
        Assert.assertEquals((long)3L, (long)fragment.getChildNodes().getLength());
        Assert.assertEquals((Object)"b", (Object)fragment.getChildNodes().item(1).getNodeName());
    }
}

