/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.util.List;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseTreeSerializer;
import org.apache.shindig.gadgets.parse.ParsedHtmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCachingGadgetHtmlParser
implements GadgetHtmlParser {
    private final Cache<String, byte[]> parseTreeCache;
    private final ParseTreeSerializer pts;
    private final int cacheTimeMsCutoff;

    protected abstract List<ParsedHtmlNode> doParse(String var1) throws GadgetException;

    protected AbstractCachingGadgetHtmlParser(CacheProvider cacheProvider, int capacity, int cacheTimeMsCutoff) {
        this.parseTreeCache = cacheProvider != null && capacity > 0 ? cacheProvider.createCache(capacity) : new DoNothingCache();
        this.pts = new ParseTreeSerializer();
        this.cacheTimeMsCutoff = cacheTimeMsCutoff;
    }

    @Override
    public List<ParsedHtmlNode> parse(String source) throws GadgetException {
        List<ParsedHtmlNode> ret;
        String cacheKey = HashUtil.checksum((byte[])source.getBytes());
        byte[] cached = (byte[])this.parseTreeCache.getElement((Object)cacheKey);
        if (cached != null && (ret = this.pts.deserialize(cached)) != null) {
            return ret;
        }
        long parseStart = System.currentTimeMillis();
        List<ParsedHtmlNode> parsed = this.doParse(source);
        if (parsed == null) {
            return null;
        }
        if (System.currentTimeMillis() - parseStart > (long)this.cacheTimeMsCutoff) {
            this.parseTreeCache.addElement((Object)cacheKey, (Object)this.pts.serialize(parsed));
        }
        return parsed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoNothingCache
    implements Cache<String, byte[]> {
        private DoNothingCache() {
        }

        public void addElement(String key, byte[] value) {
        }

        public byte[] getElement(String key) {
            return null;
        }

        public byte[] removeElement(String key) {
            return null;
        }
    }
}

