/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.net.URI;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.ContentFetcherFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.preload.Preloads;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.rewrite.ContentRewriterRegistry;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;

public class HtmlRenderer {
    private final ContentFetcherFactory fetcher;
    private final PreloaderService preloader;
    private final ContentRewriterRegistry rewriter;

    @Inject
    public HtmlRenderer(ContentFetcherFactory fetcher, PreloaderService preloader, ContentRewriterRegistry rewriter) {
        this.fetcher = fetcher;
        this.preloader = preloader;
        this.rewriter = rewriter;
    }

    public String render(Gadget gadget) throws RenderingException {
        try {
            View view = gadget.getCurrentView();
            GadgetContext context = gadget.getContext();
            GadgetSpec spec = gadget.getSpec();
            Preloads preloads = this.preloader.preload(context, spec);
            gadget.setPreloads(preloads);
            if (view.getHref() == null) {
                return this.rewriter.rewriteGadget(gadget, view.getContent());
            }
            HttpRequest request = new HttpRequest(view.getHref()).setIgnoreCache(context.getIgnoreCache()).setOAuthArguments(new OAuthArguments(view)).setAuthType(view.getAuthType()).setSecurityToken(context.getToken()).setContainer(context.getContainer()).setGadget(Uri.fromJavaUri((URI)context.getUrl()));
            HttpResponse response = this.fetcher.fetch(request);
            if (response.getHttpStatusCode() != 200) {
                throw new RenderingException("Unable to reach remote host. HTTP status " + response.getHttpStatusCode());
            }
            return this.rewriter.rewriteGadget(gadget, response.getResponseAsString());
        }
        catch (GadgetException e) {
            throw new RenderingException(e);
        }
    }
}

