/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.TtlCache;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.DefaultContentRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingContentRewriterRegistry
extends DefaultContentRewriterRegistry {
    private final TtlCache<String, String> rewrittenCache;
    private long minCacheTtl;
    private String rewritersKey;

    @Inject
    public CachingContentRewriterRegistry(List<ContentRewriter> rewriters, GadgetHtmlParser htmlParser, CacheProvider cacheProvider, @Named(value="shindig.rewritten-content.cache.capacity") int capacity, @Named(value="shindig.rewritten-content.cache.minTTL") long minCacheTtl) {
        super(rewriters, htmlParser);
        this.rewrittenCache = new TtlCache(cacheProvider, capacity, 0L, Long.MAX_VALUE);
        this.minCacheTtl = minCacheTtl;
    }

    protected String getGadgetCacheKey(Gadget gadget, String content) {
        return this.getRewritersKey() + ':' + HashUtil.checksum((byte[])content.getBytes());
    }

    protected String getHttpResponseCacheKey(HttpRequest req, HttpResponse response) {
        return this.getRewritersKey() + ':' + req.getUri().toString() + ':' + HashUtil.checksum((byte[])response.getResponseAsString().getBytes());
    }

    private String getRewritersKey() {
        if (this.rewritersKey == null) {
            StringBuilder keyBuilder = new StringBuilder();
            for (ContentRewriter rewriter : this.rewriters) {
                keyBuilder.append(rewriter.getClass().getCanonicalName()).append("-").append(rewriter.getClass().hashCode()).append(":");
            }
            this.rewritersKey = keyBuilder.toString();
        }
        return this.rewritersKey;
    }

    @Override
    public String rewriteGadget(Gadget gadget, String content) {
        if (gadget.getContext().getIgnoreCache()) {
            return super.rewriteGadget(gadget, content);
        }
        String cacheKey = this.getGadgetCacheKey(gadget, content);
        String cached = (String)this.rewrittenCache.getElement((Object)cacheKey);
        if (cached != null) {
            return cached;
        }
        MutableContent mc = this.getMutableContent(content);
        long cacheTtl = Long.MAX_VALUE;
        for (ContentRewriter rewriter : this.getRewriters()) {
            RewriterResults rr = rewriter.rewrite(gadget, mc);
            if (rr == null) {
                cacheTtl = 0L;
                continue;
            }
            cacheTtl = Math.min(cacheTtl, rr.getCacheTtl());
        }
        if (cacheTtl >= this.minCacheTtl) {
            this.rewrittenCache.addElementWithTtl((Object)cacheKey, (Object)content, cacheTtl);
        }
        return content;
    }

    @Override
    public HttpResponse rewriteHttpResponse(HttpRequest req, HttpResponse resp) {
        if (req.getIgnoreCache() || resp.getCacheTtl() <= 0L) {
            return super.rewriteHttpResponse(req, resp);
        }
        String cacheKey = this.getHttpResponseCacheKey(req, resp);
        String cached = (String)this.rewrittenCache.getElement((Object)cacheKey);
        if (cached != null) {
            return new HttpResponseBuilder(resp).setResponseString(cached).create();
        }
        String original = resp.getResponseAsString();
        MutableContent mc = this.getMutableContent(original);
        long cacheTtl = Long.MAX_VALUE;
        for (ContentRewriter rewriter : this.getRewriters()) {
            RewriterResults rr = rewriter.rewrite(req, resp, mc);
            if (rr == null) {
                cacheTtl = 0L;
                continue;
            }
            cacheTtl = Math.min(cacheTtl, rr.getCacheTtl());
        }
        if (cacheTtl >= this.minCacheTtl) {
            this.rewrittenCache.addElementWithTtl((Object)cacheKey, (Object)mc.getContent(), cacheTtl);
        }
        if (!original.equals(mc.getContent())) {
            return new HttpResponseBuilder(resp).setResponseString(mc.getContent()).create();
        }
        return resp;
    }

    void setMinCacheTtl(long minCacheTtl) {
        this.minCacheTtl = minCacheTtl;
    }
}

