/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.gadgets.parse.GadgetHtmlNode;
import org.apache.shindig.gadgets.rewrite.HtmlContentRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkingTagContentRewriter
extends HtmlContentRewriter {
    private final LinkRewriter linkRewriter;
    private final Map<String, Set<String>> tagAttributeTargets;

    public LinkingTagContentRewriter(LinkRewriter linkRewriter, Map<String, Set<String>> attributeTargets) {
        this.linkRewriter = linkRewriter;
        this.tagAttributeTargets = attributeTargets != null ? attributeTargets : LinkingTagContentRewriter.getDefaultTargets();
    }

    @Override
    protected RewriterResults rewrite(GadgetHtmlNode root, URI baseUri) {
        if (this.linkRewriter == null) {
            return null;
        }
        LinkedList<GadgetHtmlNode> nodesToProcess = new LinkedList<GadgetHtmlNode>();
        nodesToProcess.addAll(root.getChildren());
        while (!nodesToProcess.isEmpty()) {
            GadgetHtmlNode curNode = (GadgetHtmlNode)nodesToProcess.remove();
            if (curNode.isText()) continue;
            nodesToProcess.addAll(curNode.getChildren());
            Set<String> curTagAttrs = this.tagAttributeTargets.get(curNode.getTagName().toLowerCase());
            if (curTagAttrs == null) continue;
            for (String attrKey : curNode.getAttributeKeys()) {
                if (!curTagAttrs.contains(attrKey.toLowerCase())) continue;
                String attrValue = curNode.getAttributeValue(attrKey);
                curNode.setAttribute(attrKey, this.linkRewriter.rewrite(attrValue, baseUri));
            }
        }
        return RewriterResults.cacheableIndefinitely();
    }

    private static Map<String, Set<String>> getDefaultTargets() {
        HashMap<String, Set<String>> targets = new HashMap<String, Set<String>>();
        targets.put("img", new HashSet<String>(Arrays.asList("src")));
        targets.put("embed", new HashSet<String>(Arrays.asList("src")));
        targets.put("link", new HashSet<String>(Arrays.asList("href")));
        return targets;
    }
}

