/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;
import org.apache.shindig.gadgets.spec.GadgetSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptTagMerger
implements HtmlTagTransformer {
    private static final int MAX_URL_LENGTH = 1500;
    private final List<Object> scripts = new ArrayList<Object>();
    private final String concatBase;
    private final URI relativeUrlBase;
    private boolean isTagOpen = true;

    public JavascriptTagMerger(GadgetSpec spec, ContentRewriterFeature rewriterFeature, String concatBase, URI relativeUrlBase) {
        this.concatBase = concatBase + "rewriteMime" + "=text/javascript&" + "gadget=" + Utf8UrlCoder.encode((String)spec.getUrl().toString()) + "&fp=" + rewriterFeature.getFingerprint() + '&';
        this.relativeUrlBase = relativeUrlBase;
    }

    @Override
    public void accept(Token<HtmlTokenType> token, Token<HtmlTokenType> lastToken) {
        try {
            if (this.isTagOpen) {
                if (lastToken != null && lastToken.type == HtmlTokenType.ATTRNAME && lastToken.text.equalsIgnoreCase("src")) {
                    this.scripts.add(new URI(this.stripQuotes(token.text)));
                } else if (token.type == HtmlTokenType.UNESCAPED) {
                    this.scripts.add(token);
                }
            }
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    @Override
    public boolean acceptNextTag(Token<HtmlTokenType> tagStart) {
        if (tagStart.text.equalsIgnoreCase("<script")) {
            this.isTagOpen = true;
            return true;
        }
        if (tagStart.text.equalsIgnoreCase("</script")) {
            this.isTagOpen = false;
            return true;
        }
        return false;
    }

    @Override
    public String close() {
        ArrayList<URI> concat = new ArrayList<URI>();
        StringBuilder builder = new StringBuilder(100);
        for (Object o : this.scripts) {
            if (o instanceof URI) {
                concat.add((URI)o);
                continue;
            }
            this.flushConcat(concat, builder);
            builder.append("<script type=\"text/javascript\">").append(((Token)o).text).append("</script>");
        }
        this.flushConcat(concat, builder);
        this.scripts.clear();
        this.isTagOpen = true;
        return builder.toString();
    }

    private void flushConcat(List<URI> concat, StringBuilder builder) {
        if (concat.isEmpty()) {
            return;
        }
        builder.append("<script src=\"").append(this.concatBase);
        int urlStart = builder.length();
        int paramIndex = 1;
        try {
            for (int i = 0; i < concat.size(); ++i) {
                URI srcUrl = concat.get(i);
                if (!srcUrl.isAbsolute()) {
                    srcUrl = this.relativeUrlBase.resolve(srcUrl);
                }
                builder.append(paramIndex).append('=').append(URLEncoder.encode(srcUrl.toString(), "UTF-8"));
                if (i >= concat.size() - 1) continue;
                if (builder.length() - urlStart > 1500) {
                    paramIndex = 1;
                    builder.append("\" type=\"text/javascript\"></script>\n");
                    builder.append("<script src=\"").append(this.concatBase);
                    urlStart = builder.length();
                    continue;
                }
                builder.append('&');
                ++paramIndex;
            }
            builder.append("\" type=\"text/javascript\"></script>");
            concat.clear();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private String stripQuotes(String s) {
        return s.replaceAll("\"", "").replaceAll("'", "");
    }
}

