/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UserPrefs;

public class HttpGadgetContext
extends GadgetContext {
    public static final String USERPREF_PARAM_PREFIX = "up_";
    private final HttpServletRequest request;
    private final String container;
    private final Boolean debug;
    private final Boolean ignoreCache;
    private final Locale locale;
    private final Integer moduleId;
    private final RenderingContext renderingContext;
    private final URI url;
    private final UserPrefs userPrefs;
    private final String view;

    public HttpGadgetContext(HttpServletRequest request) {
        this.request = request;
        this.container = HttpGadgetContext.getContainer(request);
        this.debug = HttpGadgetContext.getDebug(request);
        this.ignoreCache = HttpGadgetContext.getIgnoreCache(request);
        this.locale = HttpGadgetContext.getLocale(request);
        this.moduleId = HttpGadgetContext.getModuleId(request);
        this.renderingContext = HttpGadgetContext.getRenderingContext(request);
        this.url = HttpGadgetContext.getUrl(request);
        this.userPrefs = HttpGadgetContext.getUserPrefs(request);
        this.view = HttpGadgetContext.getView(request);
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public String getContainer() {
        if (this.container == null) {
            return super.getContainer();
        }
        return this.container;
    }

    public String getHost() {
        String host = this.request.getHeader("Host");
        if (host == null) {
            return super.getHost();
        }
        return host;
    }

    public boolean getDebug() {
        if (this.debug == null) {
            return super.getDebug();
        }
        return this.debug;
    }

    public boolean getIgnoreCache() {
        if (this.ignoreCache == null) {
            return super.getIgnoreCache();
        }
        return this.ignoreCache;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return super.getLocale();
        }
        return this.locale;
    }

    public int getModuleId() {
        if (this.moduleId == null) {
            return super.getModuleId();
        }
        return this.moduleId;
    }

    public RenderingContext getRenderingContext() {
        if (this.renderingContext == null) {
            return super.getRenderingContext();
        }
        return this.renderingContext;
    }

    public SecurityToken getToken() {
        return new AuthInfo(this.request).getSecurityToken();
    }

    public URI getUrl() {
        if (this.url == null) {
            return super.getUrl();
        }
        return this.url;
    }

    public UserPrefs getUserPrefs() {
        if (this.userPrefs == null) {
            return super.getUserPrefs();
        }
        return this.userPrefs;
    }

    public String getView() {
        if (this.view == null) {
            return super.getView();
        }
        return this.view;
    }

    private static String getContainer(HttpServletRequest req) {
        String container = req.getParameter("container");
        if (container == null) {
            container = req.getParameter("synd");
        }
        return container;
    }

    private static Boolean getDebug(HttpServletRequest req) {
        String debug = req.getParameter("debug");
        if (debug == null) {
            return null;
        }
        if ("0".equals(debug)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean getIgnoreCache(HttpServletRequest req) {
        String ignoreCache = req.getParameter("nocache");
        if (ignoreCache == null) {
            return null;
        }
        if ("0".equals(ignoreCache)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Locale getLocale(HttpServletRequest req) {
        String language = req.getParameter("lang");
        String country = req.getParameter("country");
        if (language == null && country == null) {
            return null;
        }
        if (language == null) {
            language = "all";
        } else if (country == null) {
            country = "ALL";
        }
        return new Locale(language, country);
    }

    private static Integer getModuleId(HttpServletRequest req) {
        String mid = req.getParameter("mid");
        if (mid == null) {
            return null;
        }
        return Integer.parseInt(mid);
    }

    private static RenderingContext getRenderingContext(HttpServletRequest req) {
        String c = req.getParameter("c");
        if (c == null) {
            return null;
        }
        return c.equals("1") ? RenderingContext.CONTAINER : RenderingContext.GADGET;
    }

    private static URI getUrl(HttpServletRequest req) {
        String url = req.getParameter("url");
        if (url == null) {
            return null;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static UserPrefs getUserPrefs(HttpServletRequest req) {
        HashMap<String, String> prefs = new HashMap<String, String>();
        Enumeration paramNames = req.getParameterNames();
        if (paramNames == null) {
            return null;
        }
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith(USERPREF_PARAM_PREFIX)) continue;
            String prefName = paramName.substring(USERPREF_PARAM_PREFIX.length());
            prefs.put(prefName, req.getParameter(paramName));
        }
        return new UserPrefs(prefs);
    }

    private static String getView(HttpServletRequest req) {
        return req.getParameter("view");
    }
}

