/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloads;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcurrentPreloads
implements Preloads {
    private final Map<String, Future<PreloadedData>> preloads = Maps.newHashMap();

    ConcurrentPreloads() {
    }

    ConcurrentPreloads add(String key, Future<PreloadedData> futureData) {
        this.preloads.put(key, futureData);
        return this;
    }

    @Override
    public Set<String> getKeys() {
        return this.preloads.keySet();
    }

    @Override
    public PreloadedData getData(String key) throws PreloadException {
        Future<PreloadedData> future = this.preloads.get(key);
        if (future == null) {
            return null;
        }
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new PreloadException("Preloading was interrupted by thread termination.", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PreloadException) {
                throw (PreloadException)cause;
            }
            throw new PreloadException(cause);
        }
    }
}

