/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlParser;
import org.w3c.dom.html.HTMLDocument;

public class ParseModule
extends AbstractModule {
    protected void configure() {
        this.bind(GadgetHtmlParser.class).to(CajaHtmlParser.class);
        this.bind(HTMLDocument.class).toProvider(HTMLDocumentProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HTMLDocumentProvider
    implements Provider<HTMLDocument> {
        Class htmlDocImpl;

        public HTMLDocumentProvider() {
            try {
                this.htmlDocImpl = Class.forName("org.apache.html.dom.HTMLDocumentImpl");
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    this.htmlDocImpl = Class.forName("com.sun.org.apache.html.internal.dom.HTMLDocumentImpl");
                }
                catch (ClassNotFoundException cnfe2) {
                    throw new RuntimeException("Could not find HTML DOM implementation", cnfe2);
                }
            }
        }

        public HTMLDocument get() {
            try {
                return (HTMLDocument)this.htmlDocImpl.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create HTML DOM from class " + this.htmlDocImpl.getName(), e);
            }
        }
    }
}

