/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;
import org.apache.shindig.gadgets.rewrite.lexer.JavascriptTagMerger;
import org.apache.shindig.gadgets.rewrite.lexer.LinkingTagRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.StyleTagRewriter;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;

@Singleton
public class DefaultContentRewriter
implements ContentRewriter {
    private final GadgetSpecFactory specFactory;
    private final String includeUrls;
    private final String excludeUrls;
    private final String expires;
    private final Set<String> includeTags;
    private final String proxyUrl;
    private final String concatUrl;

    @Inject
    public DefaultContentRewriter(GadgetSpecFactory specFactory, @Named(value="shindig.content-rewrite.include-urls") String includeUrls, @Named(value="shindig.content-rewrite.exclude-urls") String excludeUrls, @Named(value="shindig.content-rewrite.expires") String expires, @Named(value="shindig.content-rewrite.include-tags") String includeTags, @Named(value="shindig.content-rewrite.proxy-url") String proxyUrl, @Named(value="shindig.content-rewrite.concat-url") String concatUrl) {
        this.specFactory = specFactory;
        this.includeUrls = includeUrls;
        this.excludeUrls = excludeUrls;
        this.expires = expires;
        this.proxyUrl = proxyUrl;
        this.concatUrl = concatUrl;
        this.includeTags = new HashSet<String>();
        for (String s : includeTags.split(",")) {
            if (s == null || s.trim().length() <= 0) continue;
            this.includeTags.add(s.trim().toLowerCase());
        }
    }

    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(content.getContent().length() * 110 / 100);
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)baos, original.getEncoding());
            String mimeType = original.getHeader("Content-Type");
            if (request.getRewriteMimeType() != null) {
                mimeType = request.getRewriteMimeType();
            }
            GadgetSpec spec = null;
            if (request.getGadget() != null) {
                spec = this.specFactory.getGadgetSpec(request.getGadget().toJavaUri(), false);
            }
            this.rewrite(spec, request.getUri().toJavaUri(), new StringReader(content.getContent()), mimeType, output);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        catch (GadgetException ge) {
            // empty catch block
        }
        return RewriterResults.cacheableIndefinitely();
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        StringWriter sw = new StringWriter();
        GadgetSpec spec = gadget.getSpec();
        StringReader reader = new StringReader(content.getContent());
        Uri base = spec.getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            base = view.getHref();
        }
        if (this.rewrite(spec, base.toJavaUri(), reader, "text/html", sw)) {
            content.setContent(sw.toString());
        }
        return RewriterResults.cacheableIndefinitely();
    }

    private boolean rewrite(GadgetSpec spec, URI source, Reader r, String mimeType, Writer w) {
        if (spec == null) {
            return false;
        }
        ContentRewriterFeature rewriterFeature = new ContentRewriterFeature(spec, this.includeUrls, this.excludeUrls, this.expires, this.includeTags);
        if (!rewriterFeature.isRewriteEnabled()) {
            return false;
        }
        if (this.isHTML(mimeType)) {
            HashMap<String, HtmlTagTransformer> transformerMap = new HashMap<String, HtmlTagTransformer>();
            if (this.getProxyUrl() != null) {
                LinkRewriter linkRewriter = this.createLinkRewriter(spec, rewriterFeature);
                LinkingTagRewriter rewriter = new LinkingTagRewriter(linkRewriter, source);
                HashSet<String> toProcess = new HashSet<String>(rewriter.getSupportedTags());
                toProcess.retainAll(rewriterFeature.getIncludedTags());
                for (String tag : toProcess) {
                    transformerMap.put(tag, rewriter);
                }
                if (rewriterFeature.getIncludedTags().contains("style")) {
                    transformerMap.put("style", new StyleTagRewriter(source, linkRewriter));
                }
            }
            if (this.getConcatUrl() != null && rewriterFeature.getIncludedTags().contains("script")) {
                transformerMap.put("script", new JavascriptTagMerger(spec, rewriterFeature, this.getConcatUrl(), source));
            }
            HtmlRewriter.rewrite(r, source, transformerMap, w);
            return true;
        }
        if (this.isCSS(mimeType)) {
            if (this.getProxyUrl() != null) {
                CssRewriter.rewrite(r, source, this.createLinkRewriter(spec, rewriterFeature), w);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isHTML(String mime) {
        if (mime == null) {
            return false;
        }
        return mime.toLowerCase().contains("html");
    }

    private boolean isCSS(String mime) {
        if (mime == null) {
            return false;
        }
        return mime.toLowerCase().contains("css");
    }

    protected String getProxyUrl() {
        return this.proxyUrl;
    }

    protected String getConcatUrl() {
        return this.concatUrl;
    }

    protected LinkRewriter createLinkRewriter(GadgetSpec spec, ContentRewriterFeature rewriterFeature) {
        return new ProxyingLinkRewriter(spec.getUrl().toJavaUri(), rewriterFeature, this.getProxyUrl());
    }
}

