/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.servlet.JsonRpcHandler;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.json.JSONException;
import org.json.JSONObject;

public class RpcServlet
extends InjectedServlet {
    static final String GET_REQUEST_REQ_PARAM = "req";
    static final String GET_REQUEST_CALLBACK_PARAM = "callback";
    static final Pattern GET_REQUEST_CALLBACK_PATTERN = Pattern.compile("[A-Za-z_\\.]+");
    private static final int POST_REQUEST_MAX_SIZE = 131072;
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");
    private JsonRpcHandler jsonHandler;

    @Inject
    public void setJsonRpcHandler(JsonRpcHandler jsonHandler) {
        this.jsonHandler = jsonHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String callbackValue;
        String reqValue;
        try {
            reqValue = this.validateParameterValue(request, GET_REQUEST_REQ_PARAM);
            callbackValue = this.validateParameterValue(request, GET_REQUEST_CALLBACK_PARAM);
            if (!GET_REQUEST_CALLBACK_PATTERN.matcher(callbackValue).matches()) {
                throw new IllegalArgumentException("Wrong format for parameter 'callback' specified. Expected: " + GET_REQUEST_CALLBACK_PATTERN.toString());
            }
        }
        catch (IllegalArgumentException e) {
            response.setStatus(400);
            logger.log(Level.INFO, e.getMessage(), e);
            return;
        }
        Result result = this.process(request, response, reqValue.getBytes());
        response.getWriter().write(result.isSuccess() ? callbackValue + "(" + result.getOutput() + ")" : result.getOutput());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int length = request.getContentLength();
        if (length <= 0) {
            logger.info("No Content-Length specified.");
            response.setStatus(411);
            return;
        }
        if (length > 131072) {
            logger.info("Request size too large: " + length);
            response.setStatus(413);
            return;
        }
        ServletInputStream is = request.getInputStream();
        byte[] body = IOUtils.toByteArray((InputStream)is);
        if (body.length != length) {
            logger.info("Wrong size. Length: " + length + " real: " + body.length);
            response.setStatus(400);
            return;
        }
        Result result = this.process(request, response, body);
        response.getWriter().write(result.getOutput());
    }

    private String validateParameterValue(HttpServletRequest request, String parameter) throws IllegalArgumentException {
        String result = request.getParameter(parameter);
        if (result == null) {
            throw new IllegalArgumentException("No parameter '" + parameter + "' specified.");
        }
        return result;
    }

    private Result process(HttpServletRequest request, HttpServletResponse response, byte[] body) {
        try {
            String encoding = this.getRequestCharacterEncoding(request);
            JSONObject req = new JSONObject(new String(body, encoding));
            JSONObject resp = this.jsonHandler.process(req);
            response.setStatus(200);
            response.setContentType("application/json; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=rpc.txt");
            return new Result(resp.toString(), true);
        }
        catch (UnsupportedEncodingException e) {
            response.setStatus(400);
            logger.log(Level.INFO, e.getMessage(), e);
            return new Result("Unsupported input character set", false);
        }
        catch (JSONException e) {
            response.setStatus(400);
            return new Result("Malformed JSON request.", false);
        }
        catch (RpcException e) {
            response.setStatus(500);
            logger.log(Level.INFO, e.getMessage(), e);
            return new Result(e.getMessage(), false);
        }
    }

    private String getRequestCharacterEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static class Result {
        private final String output;
        private final boolean success;

        public Result(String output, boolean success) {
            this.output = output;
            this.success = success;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

