/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import org.apache.shindig.gadgets.FeedProcessor;
import org.apache.shindig.gadgets.GadgetException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class FeedProcessorTest {
    private static final String FEED_TITLE = "Example Feed";
    private static final String FEED_AUTHOR = "John Doe";
    private static final String FEED_AUTHOR_EMAIL = "john.doe@example.com";
    private static final String FEED_ENTRY_TITLE = "Atom-Powered Robots Run Amok";
    private static final String FEED_ENTRY_LINK = "http://example.org/2003/12/13/entry03";
    private static final String FEED_ENTRY_SUMMARY = "Some text.";
    private static final String URL_RSS = "http://www.example.com/rss.xml";
    private static final long TIMESTAMP = 1212790800000L;
    private static final String DATE_RSS = "Fri, 06 Jun 2008 22:20:00 GMT";
    private static final String DATA_RSS = "<?xml version=\"1.0\" encoding=\"utf-8\"?><rss version=\"2.0\"><channel><title>Example Feed</title><link>http://example.org/</link><description>Example RSS Feed</description><pubDate>Sun, 19 May 2002 15:21:36 GMT</pubDate><item><title>Atom-Powered Robots Run Amok</title><link>http://example.org/2003/12/13/entry03</link><guid>http://example.org/2003/12/13/entry03#item1</guid><pubDate>Fri, 06 Jun 2008 22:20:00 GMT</pubDate><description>Some text.</description><author>john.doe@example.com</author></item><item><title>Atom-Powered Robots Run Amok</title><link>http://example.org/2003/12/13/entry03</link><guid>http://example.org/2003/12/13/entry03#item1</guid><description>Some text.</description></item></channel></rss>";
    private static final String URL_ATOM = "http://www.example.com/feed.atom";
    private static final String DATE_ATOM = "2008-06-06T22:20:00Z";
    private static final String DATA_ATOM = "<?xml version=\"1.0\" encoding=\"utf-8\"?><feed xmlns=\"http://www.w3.org/2005/Atom\"><title>Example Feed</title><link href=\"http://example.org/\"/><updated>2003-12-13T18:30:02Z</updated><id>urn:uuid:60a76c80-d399-11d9-b93C-0003939e0af6</id><author><name>John Doe</name></author><entry><title>Atom-Powered Robots Run Amok</title><link href=\"http://example.org/2003/12/13/entry03\"/><id>urn:uuid:1225c695-cfb8-4ebb-aaaa-80da344efa6a</id><updated>2008-06-06T22:20:00Z</updated><summary>Some text.</summary></entry><entry><title>Atom-Powered Robots Run Amok</title><link href=\"http://example.org/2003/12/13/entry03\"/><id>urn:uuid:1225c695-cfb8-4ebb-aaaa-80da3443fa6a</id><summary>Some text.</summary></entry></feed>";
    private static final String BAD_XML = "broken xml !!!! & ><";
    private static final String INVALID_XML = "<data><foo/></data>";
    private final FeedProcessor processor = new FeedProcessor();

    @Test
    public void parseRss() throws Exception {
        JSONObject feed = this.processor.process(URL_RSS, DATA_RSS, true, 1);
        Assert.assertEquals((Object)URL_RSS, (Object)feed.getString("URL"));
        Assert.assertEquals((Object)FEED_TITLE, (Object)feed.getString("Title"));
        Assert.assertEquals((Object)FEED_AUTHOR_EMAIL, (Object)feed.getString("Author"));
        JSONArray entryArray = feed.getJSONArray("Entry");
        JSONObject entry = entryArray.getJSONObject(0);
        Assert.assertEquals((long)1L, (long)entryArray.length());
        Assert.assertEquals((Object)FEED_ENTRY_TITLE, (Object)entry.getString("Title"));
        Assert.assertEquals((Object)FEED_ENTRY_LINK, (Object)entry.getString("Link"));
        Assert.assertEquals((Object)FEED_ENTRY_SUMMARY, (Object)entry.getString("Summary"));
    }

    @Test
    public void parseRssMultiple() throws Exception {
        JSONObject feed = this.processor.process(URL_RSS, DATA_RSS, true, 2);
        JSONArray entryArray = feed.getJSONArray("Entry");
        Assert.assertEquals((long)2L, (long)entryArray.length());
    }

    @Test
    public void parseRssDate() throws Exception {
        JSONObject feed = this.processor.process(URL_RSS, DATA_RSS, true, 2);
        JSONArray entryArray = feed.getJSONArray("Entry");
        Assert.assertEquals((long)1212790800000L, (long)entryArray.getJSONObject(0).getLong("Date"));
        Assert.assertEquals((long)0L, (long)entryArray.getJSONObject(1).getLong("Date"));
    }

    @Test
    public void parseRssNoSummaries() throws Exception {
        JSONObject feed = this.processor.process(URL_RSS, DATA_RSS, false, 1);
        feed.getJSONArray("Entry");
        JSONObject entry = feed.getJSONArray("Entry").getJSONObject(0);
        Assert.assertNull((String)"Summary should not be returned when getSummaries is false", (Object)entry.optString("Summary", null));
    }

    @Test
    public void parseAtom() throws Exception {
        JSONObject feed = this.processor.process(URL_ATOM, DATA_ATOM, true, 1);
        Assert.assertEquals((Object)URL_ATOM, (Object)feed.getString("URL"));
        Assert.assertEquals((Object)FEED_TITLE, (Object)feed.getString("Title"));
        Assert.assertEquals((Object)FEED_AUTHOR, (Object)feed.getString("Author"));
        JSONArray entryArray = feed.getJSONArray("Entry");
        JSONObject entry = entryArray.getJSONObject(0);
        Assert.assertEquals((long)1L, (long)entryArray.length());
        Assert.assertEquals((Object)FEED_ENTRY_TITLE, (Object)entry.getString("Title"));
        Assert.assertEquals((Object)FEED_ENTRY_LINK, (Object)entry.getString("Link"));
        Assert.assertEquals((Object)FEED_ENTRY_SUMMARY, (Object)entry.getString("Summary"));
    }

    @Test
    public void parseAtomMultiple() throws Exception {
        JSONObject feed = this.processor.process(URL_ATOM, DATA_ATOM, true, 2);
        JSONArray entryArray = feed.getJSONArray("Entry");
        Assert.assertEquals((long)2L, (long)entryArray.length());
    }

    @Test
    public void parseAtomDate() throws Exception {
        JSONObject feed = this.processor.process(URL_ATOM, DATA_ATOM, true, 2);
        JSONArray entryArray = feed.getJSONArray("Entry");
        Assert.assertEquals((long)1212790800000L, (long)entryArray.getJSONObject(0).getLong("Date"));
        Assert.assertEquals((long)0L, (long)entryArray.getJSONObject(1).getLong("Date"));
    }

    @Test
    public void parseAtomNoSummaries() throws Exception {
        JSONObject feed = this.processor.process(URL_ATOM, DATA_ATOM, false, 1);
        feed.getJSONArray("Entry");
        JSONObject entry = feed.getJSONArray("Entry").getJSONObject(0);
        Assert.assertNull((String)"Summary should not be returned when getSummaries is false", (Object)entry.optString("Summary", null));
    }

    @Test(expected=GadgetException.class)
    public void parseBadXml() throws GadgetException {
        this.processor.process(URL_RSS, BAD_XML, false, 1);
    }

    @Test(expected=GadgetException.class)
    public void parseInvalidXml() throws GadgetException {
        this.processor.process(URL_RSS, INVALID_XML, false, 1);
    }
}

