/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.OAuthError;
import org.apache.shindig.gadgets.oauth.OAuthResponseParams;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuthResponseParamsTest {
    private static final String APP = "http://app/example.xml";
    private HttpRequest origRequest;
    private SecurityToken token;
    private BlobCrypter crypter;
    private OAuthResponseParams params;

    @Before
    public void setUp() {
        this.crypter = new BasicBlobCrypter("abcdefafadfaxxxx".getBytes());
        this.token = (SecurityToken)EasyMock.createMock(SecurityToken.class);
        this.origRequest = new HttpRequest(Uri.parse((String)"http://originalrequest/"));
        EasyMock.expect((Object)this.token.getAppUrl()).andStubReturn((Object)APP);
        EasyMock.replay((Object[])new Object[]{this.token});
        this.params = new OAuthResponseParams(this.token, this.origRequest, this.crypter);
    }

    @Test
    public void testSetAndGet() {
        this.params.getNewClientState().setAccessToken("access");
        this.params.setAznUrl("aznurl");
        Assert.assertFalse((boolean)this.params.sendTraceToClient());
        this.params.setSendTraceToClient(true);
        Assert.assertTrue((boolean)this.params.sendTraceToClient());
        Assert.assertEquals((Object)"access", (Object)this.params.getNewClientState().getAccessToken());
        Assert.assertEquals((Object)"aznurl", (Object)this.params.getAznUrl());
    }

    @Test
    public void testAddParams() {
        this.params.getNewClientState().setAccessToken("access");
        this.params.setAznUrl("aznurl");
        this.params.oauthRequestException(OAuthError.BAD_OAUTH_CONFIGURATION, "whoa there cowboy");
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        this.params.addToResponse(responseBuilder);
        HttpResponse response = responseBuilder.create();
        Assert.assertEquals((Object)"BAD_OAUTH_CONFIGURATION", response.getMetadata().get("oauthError"));
        String errorText = (String)response.getMetadata().get("oauthErrorText");
        this.checkStringContains("error text returned", errorText, "whoa there cowboy");
        Assert.assertEquals((Object)"aznurl", response.getMetadata().get("oauthApprovalUrl"));
        Assert.assertNotNull(response.getMetadata().get("oauthState"));
        Assert.assertTrue((((String)response.getMetadata().get("oauthState")).length() > 10 ? 1 : 0) != 0);
    }

    @Test
    public void testSendTraceToClient() {
        this.params.oauthRequestException(OAuthError.BAD_OAUTH_CONFIGURATION, "whoa there cowboy");
        this.params.addRequestTrace(null, null);
        this.params.addRequestTrace(null, null);
        this.params.oauthRequestException(OAuthError.BAD_OAUTH_CONFIGURATION, "whoa there cowboy");
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        this.params.addToResponse(responseBuilder);
        HttpResponse response = responseBuilder.create();
        String errorText = (String)response.getMetadata().get("oauthErrorText");
        Assert.assertEquals((Object)"whoa there cowboy", (Object)errorText);
        this.params.setSendTraceToClient(true);
        this.params.addToResponse(responseBuilder);
        response = responseBuilder.create();
        errorText = (String)response.getMetadata().get("oauthErrorText");
        this.checkStringContains("includes error text", errorText, "whoa there cowboy");
        this.checkStringContains("Request 1 logged", errorText, "Sent request 1:\n\n");
        this.checkStringContains("Request 2 logged", errorText, "Sent request 2:\n\n");
    }

    @Test
    public void testAddEmptyParams() {
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        this.params.addToResponse(responseBuilder);
        HttpResponse response = responseBuilder.create();
        Assert.assertTrue((boolean)response.getMetadata().isEmpty());
    }

    @Test
    public void testSawErrorResponse() {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www"));
        HttpResponse ok = new HttpResponseBuilder().setHttpStatusCode(200).create();
        HttpResponse redir = new HttpResponseBuilder().setHttpStatusCode(302).create();
        HttpResponse notFound = new HttpResponseBuilder().setHttpStatusCode(404).create();
        HttpResponse doh = new HttpResponseBuilder().setHttpStatusCode(502).create();
        OAuthResponseParams params = new OAuthResponseParams(this.token, this.origRequest, this.crypter);
        Assert.assertFalse((boolean)params.sawErrorResponse());
        params.addRequestTrace(req, ok);
        Assert.assertFalse((boolean)params.sawErrorResponse());
        params.addRequestTrace(req, redir);
        Assert.assertFalse((boolean)params.sawErrorResponse());
        params.addRequestTrace(req, null);
        Assert.assertTrue((boolean)params.sawErrorResponse());
        params = new OAuthResponseParams(this.token, this.origRequest, this.crypter);
        params.addRequestTrace(req, notFound);
        Assert.assertTrue((boolean)params.sawErrorResponse());
        params = new OAuthResponseParams(this.token, this.origRequest, this.crypter);
        params.addRequestTrace(req, doh);
        Assert.assertTrue((boolean)params.sawErrorResponse());
        params.addRequestTrace(req, ok);
        Assert.assertTrue((boolean)params.sawErrorResponse());
    }

    @Test
    public void testException() {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www"));
        HttpResponse ok = new HttpResponseBuilder().setHttpStatusCode(200).create();
        this.params.addRequestTrace(req, ok);
        OAuthResponseParams.OAuthRequestException e = this.params.oauthRequestException("error", "errorText");
        this.checkStringContains(e.toString(), "[error,errorText]");
        this.params.addRequestTrace(null, null);
        RuntimeException cause = new RuntimeException();
        e = this.params.oauthRequestException(OAuthError.UNAUTHENTICATED, "errorText", (Throwable)cause);
        this.checkStringContains(e.toString(), "[UNAUTHENTICATED,errorText]");
        Assert.assertEquals((Object)cause, (Object)e.getCause());
    }

    @Test
    public void testNullSafe() {
        this.params.addRequestTrace(null, null);
        this.params.oauthRequestException("error", "errorText");
        this.params.logDetailedWarning("wow");
        this.params.logDetailedWarning("new runtime", (Throwable)new RuntimeException());
    }

    @Test
    public void testStripSensitiveFromResponse() {
        this.verifyStrip("oauth_token=dbce9de6d6da692b99b39cdcde60fd83&oauth_token_secret=60c1aabe0f6db96f2719956168c08d9d");
        String out = this.verifyStrip("oauth_token=dbce9de6d6da692b99b39cdcde60fd83&oauth_token_secret=60c1aabe0f6db96f2719956168c08d9d&oauth_session_handle=ABCDEFGH");
        this.checkStringContains(out, "oauth_token=dbce");
        this.checkStringContains(out, "HTTP/1.1 200");
        out = this.verifyStrip("oauth_token_secret=x");
        this.checkStringContains(out, "oauth_token_secret=REMOVED");
        out = this.verifyStrip("foo&oauth_token_secret=!@#$%$^&(()&");
        this.checkStringContains(out, "foo&oauth_token_secret=REMOVED&");
    }

    private String verifyStrip(String body) {
        HttpResponseBuilder resp = new HttpResponseBuilder().setHttpStatusCode(200).setHeader("Date", "Date: Fri, 09 Jan 2009 00:35:08 GMT").setResponseString(body);
        String out = OAuthResponseParams.filterSecrets((String)resp.create().toString());
        if (out.contains("oauth_token_secret")) {
            this.checkStringContains("should remove secret", out, "oauth_token_secret=REMOVED");
        }
        if (out.contains("oauth_session_handle")) {
            this.checkStringContains("should remove handle", out, "oauth_session_handle=REMOVED");
        }
        return out;
    }

    @Test
    public void testStripSecretsFromRequestHeader() {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.example.com/foo"));
        req.setHeader("Authorization", "OAuth opensocial_owner_id=\"owner\", opensocial_viewer_id=\"owner\", opensocial_app_id=\"app\", opensocial_app_url=\"http%3A%2F%2Fwww.example.com%2Fheader.xml\", oauth_version=\"1.0\", oauth_timestamp=\"1231461306\", oauth_consumer_key=\"consumer\", oauth_signature_method=\"HMAC-SHA1\", oauth_nonce=\"1231461308333563000\", oauth_session_handle=\"w0zAI1yN5ZRvmBX5kcVdra5%2BbZE%3D\"");
        String filtered = OAuthResponseParams.filterSecrets((String)req.toString());
        this.checkStringContains(filtered, "oauth_session_handle=REMOVED");
    }

    @Test
    public void testStripSecretsFromRequestUrl() {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.example.com/access?param=foo&opensocial_owner_id=owner&opensocial_viewer_id=owner&opensocial_app_id=app&oauth_session_handle=http%3A%2F%2Fwww.example.com%2Fgadget.xml&oauth_version=1.0&oauth_timestamp=1231461132&oauth_consumer_key=consumer&oauth_signature_method=HMAC-SHA1&oauth_nonce=1231461160262578000&oauth_signature=HuFQ%2BRYTrRzcgsi3al6ld9Msvoo%3D"));
        String filtered = OAuthResponseParams.filterSecrets((String)req.toString());
        this.checkStringContains(filtered, "oauth_session_handle=REMOVED");
    }

    private void checkStringContains(String text, String expected) {
        if (!text.contains(expected)) {
            Assert.fail((String)("expected [" + expected + "], got + [" + text + ']'));
        }
    }

    private void checkStringContains(String message, String text, String expected) {
        if (!text.contains(expected)) {
            Assert.fail((String)(message + ", expected [" + expected + "], got + [" + text + ']'));
        }
    }
}

