/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import org.apache.shindig.gadgets.parse.AbstractParserAndSerializerTest;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoHtmlParser;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;

public class NekoParserAndSerializeTest
extends AbstractParserAndSerializerTest {
    private NekoSimplifiedHtmlParser simple = new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get());
    private NekoHtmlParser full = new NekoHtmlParser(new ParseModule.DOMImplementationProvider().get());

    public void testDocWithDoctype() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-expected.html");
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.simple);
    }

    public void testDocNoDoctype() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-fulldocnodoctype.html");
        NekoParserAndSerializeTest.assertNull((Object)this.full.parseDom(content).getDoctype());
        NekoParserAndSerializeTest.assertNull((Object)this.simple.parseDom(content).getDoctype());
    }

    public void testNotADocument() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-fragment.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-fragment-expected.html");
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.simple);
    }

    public void testNoBody() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-headnobody.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-headnobody-expected.html");
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.simple);
    }
}

