/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.render.SanitizingRequestRewriter;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RequestRewriter;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SanitizingRequestRewriterTest
extends BaseRewriterTestCase {
    private static final Uri CONTENT_URI = Uri.parse((String)"www.example.org/content");

    private String rewrite(HttpRequest request, HttpResponse response) throws Exception {
        request.setSanitizationRequested(true);
        RequestRewriter rewriter = this.createRewriter(Collections.<String>emptySet(), Collections.<String>emptySet());
        MutableContent mc = new MutableContent(this.parser, response);
        if (!rewriter.rewrite(request, response, mc)) {
            return null;
        }
        return mc.getContent();
    }

    private RequestRewriter createRewriter(Set<String> tags, Set<String> attributes) {
        ContentRewriterFeatureFactory rewriterFeatureFactory = new ContentRewriterFeatureFactory(null, (ContainerConfig)new BaseRewriterTestCase.FakeContainerConfig());
        return new SanitizingRequestRewriter(rewriterFeatureFactory, this.rewriterUris, new CajaCssSanitizer(new CajaCssParser()));
    }

    @Test
    public void enforceInvalidProxedCssRejected() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/css");
        HttpResponse response = new HttpResponseBuilder().setResponseString("doEvil()").create();
        String sanitized = "";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(req, response));
    }

    @Test
    public void enforceValidProxedCssAccepted() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/css");
        HttpResponse response = new HttpResponseBuilder().setResponseString("@import url('http://www.evil.com/more.css'); A { font : BOLD }").create();
        String sanitized = "@import url('http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.evil.com%2Fmore.css\\26 fp=45508\\26sanitize=1\\26rewriteMime=text/css');\nA {\n  font: BOLD\n}";
        String rewritten = this.rewrite(req, response);
        Assert.assertEquals((Object)sanitized, (Object)rewritten);
    }

    @Test
    public void enforceInvalidProxedImageRejected() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("image/*");
        HttpResponse response = new HttpResponseBuilder().setResponse("NOTIMAGE".getBytes()).create();
        String sanitized = "";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(req, response));
    }

    @Test
    public void validProxiedImageAccepted() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("image/*");
        HttpResponse response = new HttpResponseBuilder().setResponse(IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/image/inefficient.png"))).create();
        Assert.assertNull((Object)this.rewrite(req, response));
    }
}

