/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.caja.CajaCssLexerParser;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.CssRequestRewriter;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CssRequestRewriterTest
extends BaseRewriterTestCase {
    private CssRequestRewriter rewriter;
    private Uri dummyUri;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ContentRewriterFeature overrideFeature = this.rewriterFeatureFactory.get(CssRequestRewriterTest.createSpecWithRewrite(".*", ".*exclude.*", "HTTP", HTMLContentRewriter.TAGS), "shindig");
        ContentRewriterFeatureFactory factory = this.mockContentRewriterFeatureFactory(overrideFeature);
        this.rewriter = new CssRequestRewriter(factory, this.rewriterUris, new CajaCssLexerParser(), (ContainerConfig)new BaseRewriterTestCase.FakeContainerConfig());
        this.dummyUri = Uri.parse((String)"http://www.w3c.org");
    }

    @Test
    public void testCssBasic() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic.css"));
        String expected = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic-expected.css"));
        HttpRequest request = new HttpRequest(Uri.parse((String)"http://www.example.org/path/rewritebasic.css"));
        request.setMethod("GET");
        request.setGadget(SPEC_URL);
        HttpResponse response = new HttpResponseBuilder().setHeader("Content-Type", "text/css").setResponseString(content).create();
        MutableContent mc = new MutableContent(null, content);
        this.rewriter.rewrite(request, response, mc);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)mc.getContent()));
    }

    @Test
    public void testCssWithContainerProxy() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic.css"));
        String expected = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic-expected.css"));
        expected = CssRequestRewriterTest.replaceDefaultWithMockServer(expected);
        HttpRequest request = new HttpRequest(Uri.parse((String)"http://www.example.org/path/rewritebasic.css"));
        request.setMethod("GET");
        request.setGadget(SPEC_URL);
        request.setContainer("mock");
        HttpResponse response = new HttpResponseBuilder().setHeader("Content-Type", "text/css").setResponseString(content).create();
        MutableContent mc = new MutableContent(null, content);
        this.rewriter.rewrite(request, response, mc);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)mc.getContent()));
    }

    @Test
    public void testNoRewriteUnknownMimeType() {
        MutableContent mc = (MutableContent)this.control.createMock(MutableContent.class);
        HttpRequest req = (HttpRequest)this.control.createMock(HttpRequest.class);
        EasyMock.expect((Object)req.getRewriteMimeType()).andReturn((Object)"unknown");
        this.control.replay();
        Assert.assertFalse((boolean)this.rewriter.rewrite(req, this.fakeResponse, mc));
        this.control.verify();
    }

    private void validateRewritten(String content, Uri base, LinkRewriter linkRewriter, String expected) {
        MutableContent mc = new MutableContent(null, content);
        HttpRequest request = new HttpRequest(base);
        this.rewriter.rewrite(request, new HttpResponseBuilder().setHeader("Content-Type", "text/css").create(), mc);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)mc.getContent()));
    }

    private void validateRewritten(String content, String expected) {
        this.validateRewritten(content, this.dummyUri, this.defaultLinkRewriter, expected);
    }

    @Test
    public void testUrlDeclarationRewrite() {
        String original = "div {list-style-image:url('http://a.b.com/bullet.gif');list-style-position:outside;margin:5px;padding:0}\n.someid {background-image:url(http://a.b.com/bigimg.png);float:right;width:165px;height:23px;margin-top:4px;margin-left:5px}";
        String rewritten = "div {list-style-image:url('http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com%2Fbullet.gif&fp=1150739864');\nlist-style-position:outside;margin:5px;padding:0}\n.someid {background-image:url('http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com%2Fbigimg.png&fp=1150739864');\nfloat:right;width:165px;height:23px;margin-top:4px;margin-left:5px}";
        this.validateRewritten(original, rewritten);
    }

    @Test
    public void testExtractImports() {
        String original = " @import url(www.example.org/some.css);\n@import url('www.example.org/someother.css');\n@import url(\"www.example.org/another.css\");\n div { color: blue; }\n p { color: black; }\n span { color: red; }";
        String expected = " div { color: blue; }\n p { color: black; }\n span { color: red; }";
        StringWriter sw = new StringWriter();
        List stringList = this.rewriter.rewrite((Reader)new StringReader(original), this.dummyUri, this.defaultLinkRewriter, (Writer)sw, true);
        Assert.assertEquals((Object)expected, (Object)sw.toString());
        Assert.assertEquals((Object)stringList, (Object)Lists.newArrayList((Object[])new String[]{"www.example.org/some.css", "www.example.org/someother.css", "www.example.org/another.css"}));
    }
}

