/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.parse.caja.CajaCssLexerParser;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.CssRequestRewriter;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.XPathWrapper;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class HTMLContentRewriterTest
extends BaseRewriterTestCase {
    private HTMLContentRewriter rewriter;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ContentRewriterFeature overrideFeature = this.rewriterFeatureFactory.get(HTMLContentRewriterTest.createSpecWithRewrite(".*", ".*exclude.*", "HTTP", HTMLContentRewriter.TAGS), "shindig");
        ContentRewriterFeatureFactory factory = this.mockContentRewriterFeatureFactory(overrideFeature);
        this.rewriter = new HTMLContentRewriter(factory, this.rewriterUris, new CssRequestRewriter(factory, this.rewriterUris, new CajaCssLexerParser(), (ContainerConfig)new BaseRewriterTestCase.FakeContainerConfig()), (ContainerConfig)new BaseRewriterTestCase.FakeContainerConfig());
    }

    @Test
    public void testScriptsBasic() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritescriptbasic.html"));
        Document doc = this.rewriteContent((GadgetRewriter)this.rewriter, content, null).getDocument();
        XPathWrapper wrapper = new XPathWrapper(doc);
        Assert.assertEquals((Object)"headScript1", (Object)wrapper.getValue("/html/head/script"));
        Assert.assertEquals((long)1L, (long)wrapper.getNodeList("/html/head/script").getLength());
        Assert.assertEquals((long)8L, (long)wrapper.getNodeList("/html/body/script").getLength());
        Assert.assertEquals((Object)"bodyScript1", (Object)wrapper.getValue("/html/body/script[1]"));
        Assert.assertEquals((Object)wrapper.getValue("/html/body/script[2]/@src"), (Object)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F1.js&2=http%3A%2F%2Fwww.example.org%2F2.js");
        Assert.assertEquals((Object)"bodyScript2", (Object)wrapper.getValue("/html/body/script[3]"));
        Assert.assertEquals((Object)wrapper.getValue("/html/body/script[4]/@src"), (Object)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F3.js");
        Assert.assertEquals((Object)"<!-- retain-comment -->", (Object)wrapper.getValue("/html/body/script[5]"));
        Assert.assertEquals((Object)wrapper.getValue("/html/body/script[6]/@src"), (Object)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F4.js");
        Assert.assertEquals((Object)"http://www.example.org/excluded/5.js", (Object)wrapper.getValue("/html/body/script[7]/@src"));
        Assert.assertEquals((Object)wrapper.getValue("/html/body/script[8]/@src"), (Object)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F6.js");
    }

    @Test
    public void testScriptsForContainer() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritescriptbasic.html"));
        String text = this.rewriteContent((GadgetRewriter)this.rewriter, content, "mock").getContent();
        System.out.println("\n\n\n\n text " + text);
        Assert.assertTrue((boolean)text.contains("http://www.test.com/dir/concat?"));
    }

    @Test
    public void testLinksBasic() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritelinksbasic.html"));
        Document doc = this.rewriteContent((GadgetRewriter)this.rewriter, content, null).getDocument();
        XPathWrapper wrapper = new XPathWrapper(doc);
        Assert.assertEquals((Object)wrapper.getValue("//img[1]/@src"), (Object)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fimg.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864");
        Assert.assertEquals((Object)"http://www.example.org/excluded/img.gif", (Object)wrapper.getValue("//img[2]/@src"));
        Assert.assertEquals((Object)wrapper.getValue("//embed[1]/@src"), (Object)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fsome.swf&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864");
        Assert.assertEquals((Object)"http://www.example.org/excluded/some.swf", (Object)wrapper.getValue("//embed[2]/@src"));
    }

    @Test
    public void testLinksForContainer() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritelinksbasic.html"));
        String text = this.rewriteContent((GadgetRewriter)this.rewriter, content, "mock").getContent();
        Assert.assertTrue((boolean)text.contains("http://www.test.com/dir/proxy?url="));
    }

    @Test
    public void testStyleBasic() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritestylebasic.html"));
        MutableContent mc = this.rewriteContent((GadgetRewriter)this.rewriter, content, null);
        Document doc = mc.getDocument();
        XPathWrapper wrapper = new XPathWrapper(doc);
        Assert.assertEquals((Object)wrapper.getValue("//link[1]/@href"), (Object)"http://www.test.com/dir/concat?rewriteMime=text/css&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2Flinkedstyle1.css&2=http%3A%2F%2Fwww.example.org%2Flinkedstyle3.css&3=http%3A%2F%2Fwww.example.org%2Fimportedstyle1.css&4=http%3A%2F%2Fwww.example.org%2Fimportedstyle3.css&5=http%3A%2F%2Fwww.example.org%2Fimportedstyle4.css");
        Assert.assertEquals((Object)"http://www.example.org/excluded/linkedstyle2.css", (Object)wrapper.getValue("//link[2]/@href"));
        Assert.assertEquals((Object)"/excluded/importedstyle2.css", (Object)wrapper.getValue("//link[3]/@href"));
        Assert.assertEquals((long)1L, (long)wrapper.getNodeList("//style").getLength());
        Assert.assertEquals((Object)"div { color : black; }", (Object)wrapper.getValue("//style[1]").trim());
    }

    @Test
    public void testStyleBasic2() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritestyle2.html"));
        String expected = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritestyle2-expected.html"));
        MutableContent mc = this.rewriteContent((GadgetRewriter)this.rewriter, content, null);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)mc.getContent()), (Object)StringUtils.deleteWhitespace((String)expected));
    }

    @Test
    public void testStyleForContainer() throws Exception {
        String content = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritestylebasic.html"));
        String text = this.rewriteContent((GadgetRewriter)this.rewriter, content, "mock").getContent();
        Assert.assertTrue((boolean)text.contains("http://www.test.com/dir/concat?"));
    }

    @Test
    public void testNoRewriteUnknownMimeType() {
        MutableContent mc = (MutableContent)this.control.createMock(MutableContent.class);
        HttpRequest req = (HttpRequest)this.control.createMock(HttpRequest.class);
        EasyMock.expect((Object)req.getRewriteMimeType()).andReturn((Object)"unknown");
        this.control.replay();
        Assert.assertFalse((boolean)this.rewriter.rewrite(req, this.fakeResponse, mc));
        this.control.verify();
    }
}

