/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.junit.Assert;
import org.junit.Test;

public class ProxyingLinkRewriterTest
extends BaseRewriterTestCase {
    private String rewrite(String uri) {
        return this.defaultLinkRewriter.rewrite(uri, SPEC_URL);
    }

    @Test
    public void testAbsoluteRewrite() {
        String val = "http://a.b.com";
        Assert.assertEquals((Object)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (Object)this.rewrite(val));
    }

    @Test
    public void testHostRelativeRewrite() {
        String val = "/somepath/test.gif";
        Assert.assertEquals((Object)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fsomepath%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (Object)this.rewrite(val));
    }

    @Test
    public void testPathRelativeRewrite() {
        String val = "test.gif";
        Assert.assertEquals((Object)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fdir%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (Object)this.rewrite(val));
    }

    @Test
    public void testLeadingAndTrailingSpace() {
        String val = " test.gif ";
        Assert.assertEquals((Object)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fdir%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (Object)this.rewrite(val));
    }

    @Test
    public void testWithRefresh() throws Exception {
        ContentRewriterFeature contentRewriterFeature = new ContentRewriterFeature(ProxyingLinkRewriterTest.createSpecWithoutRewrite(), ".*", "", "86400", (Set)ImmutableSet.of((Object[])new String[]{"embed", "img", "script", "link", "style"}));
        ProxyingLinkRewriter rewriter = new ProxyingLinkRewriter(SPEC_URL, contentRewriterFeature, "http://www.test.com/dir/proxy?url=");
        String val = " test.gif ";
        Assert.assertEquals((Object)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fdir%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&refresh=86400", (Object)rewriter.rewrite(val, SPEC_URL));
    }

    @Test
    public void testInvalidCharRewrite() {
        String val = "/images/opensocial/movie_trivia/76/${quiz.picture_url}";
        Assert.assertEquals((Object)val, (Object)this.rewrite(val));
    }

    @Test
    public void testEmpty() {
        String val = " ";
        Assert.assertEquals((Object)"", (Object)this.rewrite(val));
    }
}

