/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizerTest;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.rewrite.image.PNGOptimizer;

public class PNGOptimizerTest
extends BaseOptimizerTest {
    public void testRewriteInefficientPNG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/inefficient.png", "image/png");
        HttpResponse httpResponse = this.rewrite(resp);
        PNGOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        PNGOptimizerTest.assertEquals((String)httpResponse.getHeader("Content-Type"), (String)"image/png");
    }

    public void testStripAlpha() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/rgbawithnoalpha.png", "image/png");
        HttpResponse httpResponse = this.rewrite(resp);
        PNGOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        PNGOptimizerTest.assertEquals((String)httpResponse.getHeader("Content-Type"), (String)"image/png");
    }

    public void testEvil() throws Exception {
        try {
            HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/evil.png", "image/png");
            this.rewrite(resp);
            PNGOptimizerTest.fail((String)"Should have failed to read image");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    HttpResponse rewrite(HttpResponse original) throws IOException, ImageReadException {
        return new PNGOptimizer(new OptimizerConfig(), original).rewrite(Sanselan.getBufferedImage((InputStream)original.getResponse()));
    }
}

