/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.el.ELResolver;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.RootELResolver;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipelinedDataTest {
    private static final Uri GADGET_URI = Uri.parse((String)"http://example.org/");
    private ELResolver elResolver;
    private Map<String, Object> elValues;
    private Expressions expressions;

    @Before
    public void setUp() {
        this.elValues = Maps.newHashMap();
        this.elResolver = new RootELResolver(this.elValues);
        this.expressions = Expressions.forTesting();
    }

    @Test
    public void testDataRequest() throws Exception {
        String xml = "<Content><DataRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" method=\"people.get\" groupId=\"${params.groupId}\" userId=\"${userIds}\" startIndex=\"${startIndex}\" fields=\"${fields}\"/></Content>";
        this.elValues.put("startIndex", 10);
        this.elValues.put("params", ImmutableMap.of());
        this.elValues.put("userIds", Lists.newArrayList((Object[])new String[]{"first", "second"}));
        this.elValues.put("fields", new JSONArray("['name','id']"));
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertFalse((boolean)socialData.needsOwner());
        Assert.assertFalse((boolean)socialData.needsViewer());
        JSONObject expected = new JSONObject("{method: 'people.get', id: 'key', params:{userId: ['first','second'],startIndex: 10,fields: ['name','id']}}");
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertEquals((Object)expected.toString(), (Object)batch.getSocialPreloads().get("key").toString());
    }

    @Test
    public void testPeopleRequest() throws Exception {
        String xml = "<Content><PeopleRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" groupId=\"group\" userId=\"first,second\" startIndex=\"20\" count=\"10\" fields=\"name,id\"/></Content>";
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertFalse((boolean)socialData.needsOwner());
        Assert.assertFalse((boolean)socialData.needsViewer());
        JSONObject expected = new JSONObject("{method: 'people.get', id: 'key', params:{groupId: 'group',userId: ['first','second'],startIndex: 20,count: 10,fields: ['name','id']}}");
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertEquals((Object)expected.toString(), (Object)batch.getSocialPreloads().get("key").toString());
        Assert.assertNull((Object)batch.getNextBatch(this.elResolver));
    }

    @Test
    public void testPeopleRequestWithExpressions() throws Exception {
        String xml = "<Content><PeopleRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" groupId=\"group\" userId=\"first,second\" startIndex=\"20\" count=\"${count}\" fields=\"${fields}\"/></Content>";
        this.elValues.put("count", 10);
        this.elValues.put("fields", "name,id");
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertFalse((boolean)socialData.needsOwner());
        Assert.assertFalse((boolean)socialData.needsViewer());
        JSONObject expected = new JSONObject("{method: 'people.get', id: 'key', params:{groupId: 'group',userId: ['first','second'],startIndex: 20,count: 10,fields: ['name','id']}}");
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertEquals((Object)expected.toString(), (Object)batch.getSocialPreloads().get("key").toString());
    }

    @Test
    public void testViewerRequest() throws Exception {
        String xml = "<Content><ViewerRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" fields=\"name,id\"/></Content>";
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertFalse((boolean)socialData.needsOwner());
        Assert.assertTrue((boolean)socialData.needsViewer());
        JSONObject expected = new JSONObject("{method: 'people.get', id: 'key', params:{userId: ['@viewer'],fields: ['name','id']}}");
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertEquals((Object)expected.toString(), (Object)batch.getSocialPreloads().get("key").toString());
    }

    @Test
    public void testOwnerRequest() throws Exception {
        String xml = "<Content><OwnerRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" fields=\"name,id\"/></Content>";
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertTrue((boolean)socialData.needsOwner());
        Assert.assertFalse((boolean)socialData.needsViewer());
        JSONObject expected = new JSONObject("{method: 'people.get', id: 'key', params:{userId: ['@owner'],fields: ['name','id']}}");
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertEquals((Object)expected.toString(), (Object)batch.getSocialPreloads().get("key").toString());
    }

    @Test
    public void testPersonAppData() throws Exception {
        String xml = "<Content><PersonAppDataRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" userId=\"@viewer\" fields=\"foo,bar\"/></Content>";
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertFalse((boolean)socialData.needsOwner());
        Assert.assertTrue((boolean)socialData.needsViewer());
        JSONObject expected = new JSONObject("{method: 'appdata.get', id: 'key', params:{userId: ['@viewer'],fields: ['foo','bar']}}");
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertEquals((Object)expected.toString(), (Object)batch.getSocialPreloads().get("key").toString());
    }

    @Test
    public void testActivitiesRequest() throws Exception {
        String xml = "<Content><ActivitiesRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" userId=\"@owner,@viewer\" fields=\"foo,bar\"/></Content>";
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertTrue((boolean)socialData.needsOwner());
        Assert.assertTrue((boolean)socialData.needsViewer());
        JSONObject expected = new JSONObject("{method: 'activities.get', id: 'key', params:{userId: ['@owner','@viewer'],fields: ['foo','bar']}}");
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertEquals((Object)expected.toString(), (Object)batch.getSocialPreloads().get("key").toString());
    }

    @Test
    public void testIgnoreNoNamespace() throws Exception {
        String xml = "<Content><PersonRequest key=\"key\" userId=\"@owner\" fields=\"name,id\"/></Content>";
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), null);
        Assert.assertFalse((boolean)socialData.needsOwner());
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertNull((Object)batch);
    }

    @Test(expected=SpecParserException.class)
    public void testErrorOnUnknownOpensocialElement() throws Exception {
        String xml = "<Content><NotARealElement xmlns=\"http://ns.opensocial.org/2008/markup\" /></Content>";
        new PipelinedData(XmlUtil.parse((String)xml), null);
    }

    @Test
    public void testBatching() throws Exception {
        String xml = "<Content xmlns=\"http://ns.opensocial.org/2008/markup\"><PeopleRequest key=\"key\" userId=\"${userId}\"/><HttpRequest key=\"key2\" href=\"${key}\"/></Content>";
        PipelinedData socialData = new PipelinedData(XmlUtil.parse((String)xml), GADGET_URI);
        PipelinedData.Batch batch = socialData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)batch.getSocialPreloads().isEmpty());
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        this.elValues.put("userId", "foo");
        batch = batch.getNextBatch(this.elResolver);
        Assert.assertEquals((long)1L, (long)batch.getSocialPreloads().size());
        Assert.assertTrue((boolean)batch.getHttpPreloads().isEmpty());
        this.elValues.put("key", "somedata");
        batch = batch.getNextBatch(this.elResolver);
        Assert.assertTrue((boolean)batch.getSocialPreloads().isEmpty());
        Assert.assertEquals((long)1L, (long)batch.getHttpPreloads().size());
        Assert.assertNull((Object)batch.getNextBatch(this.elResolver));
    }

    @Test
    public void httpRequestDefaults() throws Exception {
        String xml = "<Content><HttpRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" href=\"/example.html\"/></Content>";
        PipelinedData pipelinedData = new PipelinedData(XmlUtil.parse((String)xml), GADGET_URI);
        PipelinedData.Batch batch = pipelinedData.getBatch(this.expressions, this.elResolver);
        Assert.assertFalse((boolean)pipelinedData.needsViewer());
        Assert.assertFalse((boolean)pipelinedData.needsOwner());
        Assert.assertEquals((long)1L, (long)batch.getHttpPreloads().size());
        RequestAuthenticationInfo preload = (RequestAuthenticationInfo)batch.getHttpPreloads().get("key");
        Assert.assertEquals((Object)AuthType.NONE, (Object)preload.getAuthType());
        Assert.assertEquals((Object)Uri.parse((String)"http://example.org/example.html"), (Object)preload.getHref());
        Assert.assertTrue((boolean)batch.getSocialPreloads().isEmpty());
    }

    @Test
    public void httpRequestDefaultsSigned() throws Exception {
        String xml = "<Content><HttpRequest xmlns=\"http://ns.opensocial.org/2008/markup\"  key=\"key\" href=\"/example.html\" authz=\"signed\" sign_owner=\"false\"/></Content>";
        PipelinedData pipelinedData = new PipelinedData(XmlUtil.parse((String)xml), GADGET_URI);
        PipelinedData.Batch batch = pipelinedData.getBatch(this.expressions, this.elResolver);
        Assert.assertTrue((boolean)pipelinedData.needsViewer());
        Assert.assertFalse((boolean)pipelinedData.needsOwner());
        Assert.assertEquals((long)1L, (long)batch.getHttpPreloads().size());
        RequestAuthenticationInfo preload = (RequestAuthenticationInfo)batch.getHttpPreloads().get("key");
        Assert.assertEquals((Object)AuthType.SIGNED, (Object)preload.getAuthType());
        Assert.assertTrue((boolean)preload.isSignViewer());
        Assert.assertFalse((boolean)preload.isSignOwner());
        Assert.assertTrue((boolean)batch.getSocialPreloads().isEmpty());
    }
}

