/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import net.oauth.OAuthAccessor;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.AccessorInfo;
import org.apache.shindig.gadgets.oauth.OAuthStore;

public class AccessorInfoBuilder {
    private OAuthStore.ConsumerInfo consumer;
    private String requestToken;
    private String accessToken;
    private String tokenSecret;
    private String sessionHandle;
    private long tokenExpireMillis;
    private AccessorInfo.OAuthParamLocation location;
    private AccessorInfo.HttpMethod method;

    public AccessorInfo create() throws GadgetException {
        if (this.location == null) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "no location");
        }
        if (this.consumer == null) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "no consumer");
        }
        OAuthAccessor accessor = new OAuthAccessor(this.consumer.getConsumer());
        accessor.requestToken = this.requestToken;
        accessor.accessToken = this.accessToken;
        accessor.tokenSecret = this.tokenSecret;
        return new AccessorInfo(accessor, this.consumer, this.method, this.location, this.sessionHandle, this.tokenExpireMillis);
    }

    public void setConsumer(OAuthStore.ConsumerInfo consumer) {
        this.consumer = consumer;
    }

    public void setRequestToken(String requestToken) {
        this.requestToken = requestToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public void setParameterLocation(AccessorInfo.OAuthParamLocation location) {
        this.location = location;
    }

    public void setMethod(AccessorInfo.HttpMethod method) {
        this.method = method;
    }

    public void setSessionHandle(String sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public void setTokenExpireMillis(long tokenExpireMillis) {
        this.tokenExpireMillis = tokenExpireMillis;
    }
}

