/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssRewriter {
    private static final Pattern urlMatcher = Pattern.compile("(url\\s*\\(\\s*['\"]?)([^\\)'\"]*)(['\"]?\\s*\\))", 2);

    public static String rewrite(String content, Uri source, LinkRewriter linkRewriter) {
        StringWriter sw = new StringWriter(content.length() * 110 / 100);
        CssRewriter.rewrite(new StringReader(content), source, linkRewriter, sw, false);
        return sw.toString();
    }

    public static List<String> rewrite(Reader content, Uri source, LinkRewriter rewriter, Writer writer, boolean extractImports) {
        ArrayList imports = Lists.newArrayList();
        CharProducer producer = CharProducer.Factory.create((Reader)content, (InputSource)new InputSource(source.toJavaUri()));
        CssLexer lexer = new CssLexer(producer);
        try {
            boolean inImport = false;
            while (lexer.hasNext()) {
                Token token = lexer.next();
                if (extractImports) {
                    if (token.type == CssTokenType.SYMBOL && token.text.equalsIgnoreCase("@import")) {
                        inImport = true;
                        continue;
                    }
                    if (inImport) {
                        if (token.type == CssTokenType.URI) {
                            Matcher matcher = urlMatcher.matcher(token.text);
                            if (matcher.find()) {
                                imports.add(matcher.group(2).trim());
                            }
                        } else if (token.type != CssTokenType.SPACE && token.type != CssTokenType.PUNCTUATION) {
                            inImport = false;
                        }
                    }
                    if (inImport) continue;
                    writer.write(token.text);
                    continue;
                }
                if (token.type == CssTokenType.URI) {
                    writer.write(CssRewriter.rewriteLink((Token<CssTokenType>)token, source, rewriter));
                    continue;
                }
                writer.write(token.text);
            }
            writer.flush();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return imports;
    }

    private static String rewriteLink(Token<CssTokenType> token, Uri base, LinkRewriter rewriter) {
        Matcher matcher = urlMatcher.matcher(token.text);
        if (!matcher.find()) {
            return token.text;
        }
        return "url(\"" + rewriter.rewrite(matcher.group(2).trim(), base) + "\")";
    }
}

