/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.io.StringWriter;
import org.w3c.dom.Document;

public abstract class HtmlSerializer {
    private static final String KEY = "serializer";
    private static final String ORIGINAL_LENGTH = "original-length";

    public static void attach(Document doc, HtmlSerializer serializer, String originalContent) {
        doc.setUserData(KEY, serializer, null);
        if (originalContent != null) {
            doc.setUserData(ORIGINAL_LENGTH, originalContent.length(), null);
        }
    }

    public static void copySerializer(Document from, Document to) {
        Integer length = (Integer)from.getUserData(ORIGINAL_LENGTH);
        if (length != null) {
            to.setUserData(ORIGINAL_LENGTH, length, null);
        }
        to.setUserData(KEY, from.getUserData(KEY), null);
    }

    private static int getOriginalLength(Document doc) {
        Integer length = (Integer)doc.getUserData(ORIGINAL_LENGTH);
        if (length == null) {
            return -1;
        }
        return length;
    }

    protected static StringWriter createWriter(Document doc) {
        int originalLength = HtmlSerializer.getOriginalLength(doc);
        if (originalLength == -1) {
            return new StringWriter(8192);
        }
        return new StringWriter(originalLength * 11 / 10);
    }

    public static String serialize(Document doc) {
        return ((HtmlSerializer)doc.getUserData(KEY)).serializeImpl(doc);
    }

    protected abstract String serializeImpl(Document var1);
}

