/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.thoughtworks.xstream.converters.javabean.BeanProperty;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDictionary {
    private final Map<String, Map<String, BeanProperty>> keyedByPropertyNameCache = new ConcurrentHashMap<String, Map<String, BeanProperty>>();

    public Iterator<BeanProperty> serializablePropertiesFor(Class<?> cls) {
        return this.buildMap(cls).values().iterator();
    }

    public BeanProperty property(Class<?> cls, String name) {
        Map<String, BeanProperty> properties = this.buildMap(cls);
        BeanProperty property = properties.get(name);
        if (property == null) {
            throw new ObjectAccessException("No such property " + cls.getName() + "." + name);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BeanProperty> buildMap(Class<?> cls) {
        String clsName = cls.getName();
        if (!this.keyedByPropertyNameCache.containsKey(clsName)) {
            Map<String, Map<String, BeanProperty>> map = this.keyedByPropertyNameCache;
            synchronized (map) {
                if (!this.keyedByPropertyNameCache.containsKey(clsName)) {
                    HashMap<PropertyKey, BeanProperty> propertyMap = new HashMap<PropertyKey, BeanProperty>();
                    Method[] methods = cls.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        BeanProperty property;
                        if (!Modifier.isPublic(methods[i].getModifiers()) || Modifier.isStatic(methods[i].getModifiers())) continue;
                        String methodName = methods[i].getName();
                        Class<?>[] parameters = methods[i].getParameterTypes();
                        Class<?> returnType = methods[i].getReturnType();
                        String propertyName = null;
                        if ((methodName.startsWith("get") || methodName.startsWith("is")) && parameters.length == 0 && returnType != null) {
                            propertyName = methodName.startsWith("get") ? Introspector.decapitalize(methodName.substring(3)) : Introspector.decapitalize(methodName.substring(2));
                            property = this.getBeanProperty(propertyMap, cls, propertyName, returnType);
                            property.setGetterMethod(methods[i]);
                            continue;
                        }
                        if (!methodName.startsWith("set") || parameters.length != 1 || !returnType.equals(Void.TYPE)) continue;
                        propertyName = Introspector.decapitalize(methodName.substring(3));
                        property = this.getBeanProperty(propertyMap, cls, propertyName, parameters[0]);
                        property.setSetterMethod(methods[i]);
                    }
                    ArrayList<BeanProperty> serializableProperties = new ArrayList<BeanProperty>();
                    for (BeanProperty property : propertyMap.values()) {
                        if (!property.isReadable() && !property.isWritable()) continue;
                        serializableProperties.add(property);
                    }
                    Collections.sort(serializableProperties, new BeanPropertyComparator());
                    OrderRetainingMap<String, BeanProperty> keyedByFieldName = new OrderRetainingMap<String, BeanProperty>();
                    for (BeanProperty property : serializableProperties) {
                        keyedByFieldName.put(property.getName(), property);
                    }
                    this.keyedByPropertyNameCache.put(clsName, keyedByFieldName);
                }
            }
        }
        return this.keyedByPropertyNameCache.get(clsName);
    }

    private BeanProperty getBeanProperty(Map<PropertyKey, BeanProperty> propertyMap, Class<?> cls, String propertyName, Class<?> type) {
        PropertyKey key = new PropertyKey(propertyName, type);
        BeanProperty property = propertyMap.get(key);
        if (property == null) {
            property = new BeanProperty(cls, propertyName, type);
            propertyMap.put(key, property);
        }
        return property;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrderRetainingMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1565370254073638221L;
        private List<V> valueOrder = new ArrayList<V>();

        private OrderRetainingMap() {
        }

        @Override
        public V put(K key, V value) {
            this.valueOrder.add(value);
            return super.put(key, value);
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableList(this.valueOrder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanPropertyComparator
    implements Comparator<BeanProperty> {
        private BeanPropertyComparator() {
        }

        @Override
        public int compare(BeanProperty o1, BeanProperty o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyKey {
        private String propertyName;
        private Class<?> propertyType;

        public PropertyKey(String propertyName, Class<?> propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyKey)) {
                return false;
            }
            PropertyKey propertyKey = (PropertyKey)o;
            if (this.propertyName != null ? !this.propertyName.equals(propertyKey.propertyName) : propertyKey.propertyName != null) {
                return false;
            }
            return !(this.propertyType != null ? !this.propertyType.equals(propertyKey.propertyType) : propertyKey.propertyType != null);
        }

        public int hashCode() {
            int result = this.propertyName != null ? this.propertyName.hashCode() : 0;
            result = 29 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PropertyKey{propertyName='" + this.propertyName + "'" + ", propertyType=" + this.propertyType + "}";
        }
    }
}

