/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.core.util.BeanXStreamAtomConverter;
import org.apache.shindig.social.core.util.BeanXStreamConverter;
import org.apache.shindig.social.core.util.xstream.XStream081Configuration;
import org.apache.shindig.social.core.util.xstream.XStreamConfiguration;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.DataServiceServlet;
import org.apache.shindig.social.opensocial.service.HandlerDispatcher;
import org.easymock.classextension.EasyMock;
import org.json.JSONObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLargeRestfulTests
extends EasyMockTestCase {
    protected static final String XMLSCHEMA = " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ";
    protected static final String XSDRESOURCE = "opensocial.xsd";
    private HttpServletRequest req;
    private HttpServletResponse res;
    private DataServiceServlet servlet;
    private static final FakeGadgetToken FAKE_GADGET_TOKEN = new FakeGadgetToken().setOwnerId("john.doe").setViewerId("john.doe");

    protected HttpServletRequest getRequest() {
        return this.req;
    }

    protected void setRequest(HttpServletRequest req) {
        this.req = req;
    }

    protected HttpServletResponse getResponse() {
        return this.res;
    }

    protected void setResponse(HttpServletResponse res) {
        this.res = res;
    }

    protected DataServiceServlet getServlet() {
        return this.servlet;
    }

    protected void setServlet(DataServiceServlet servlet) {
        this.servlet = servlet;
    }

    protected void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        this.servlet = new DataServiceServlet();
        this.servlet.setHandlerDispatcher((HandlerDispatcher)injector.getInstance(HandlerDispatcher.class));
        this.servlet.setBeanConverters((BeanConverter)new BeanJsonConverter(injector), (BeanConverter)new BeanXStreamConverter((XStreamConfiguration)new XStream081Configuration(injector)), (BeanConverter)new BeanXStreamAtomConverter((XStreamConfiguration)new XStream081Configuration(injector)));
        this.req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        this.res = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
    }

    protected String getResponse(String path, String method, String format, String contentType) throws Exception {
        return this.getResponse(path, method, Maps.newHashMap(), "", format, contentType);
    }

    protected String getResponse(String path, String method, Map<String, String> extraParams, String format, String contentType) throws Exception {
        return this.getResponse(path, method, extraParams, "", format, contentType);
    }

    protected String getResponse(String path, String method, String postData, String format, String contentType) throws Exception {
        return this.getResponse(path, method, Maps.newHashMap(), postData, format, contentType);
    }

    protected String getResponse(String path, String method, Map<String, String> extraParams, String postData, String format, String contentType) throws Exception {
        EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        EasyMock.expect((Object)this.req.getPathInfo()).andStubReturn((Object)path);
        EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)method);
        EasyMock.expect((Object)this.req.getParameter("format")).andStubReturn((Object)format);
        EasyMock.expect((Object)this.req.getParameter("X-HTTP-Method-Override")).andStubReturn((Object)method);
        EasyMock.expect((Object)this.req.getAttribute((String)EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        Vector<String> vector = new Vector<String>(extraParams.keySet());
        EasyMock.expect((Object)this.req.getParameterNames()).andStubReturn(vector.elements());
        for (Map.Entry<String, String> entry : extraParams.entrySet()) {
            if (entry.getValue() != null) {
                EasyMock.expect((Object)this.req.getParameterValues(entry.getKey())).andStubReturn((Object)new String[]{entry.getValue()});
                continue;
            }
            EasyMock.expect((Object)this.req.getParameterValues(entry.getKey())).andStubReturn((Object)new String[0]);
        }
        if (postData == null) {
            postData = "";
        }
        if (!"GET".equals(method) && !"HEAD".equals(method)) {
            final ByteArrayInputStream stream = new ByteArrayInputStream(postData.getBytes());
            ServletInputStream servletStream = new ServletInputStream(){

                public int read() throws IOException {
                    return stream.read();
                }
            };
            EasyMock.expect((Object)this.req.getInputStream()).andReturn((Object)servletStream);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(outputStream);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writer);
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType(contentType);
        EasyMock.replay((Object[])new Object[]{this.req, this.res});
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.req, this.res});
        EasyMock.reset((Object[])new Object[]{this.req, this.res});
        writer.flush();
        return outputStream.toString();
    }

    protected JSONObject getJson(String json) throws Exception {
        return new JSONObject(json);
    }

    protected Map<String, String> parseXmlContent(String str) throws XMLStreamException {
        ByteArrayInputStream inStr = new ByteArrayInputStream(str.getBytes());
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(inStr);
        HashMap columns = Maps.newHashMap();
        while (true) {
            int event;
            if ((event = parser.next()) == 8) break;
            if (event != 1) continue;
            String name = parser.getLocalName();
            int eventType = parser.next();
            if (eventType != 4) continue;
            String value = parser.getText();
            columns.put(name, value);
        }
        parser.close();
        return columns;
    }

    protected Map<String, List<String>> childNodesToMap(Node n) {
        HashMap v = Maps.newHashMap();
        NodeList result = n.getChildNodes();
        for (int i = 0; i < result.getLength(); ++i) {
            Node nv = result.item(i);
            if (nv.getNodeType() != 1) continue;
            List l = (List)v.get(nv.getLocalName());
            if (l == null) {
                l = Lists.newArrayList();
                v.put(nv.getLocalName(), l);
            }
            l.add(nv.getTextContent());
        }
        return v;
    }

    protected Map<String, Map<String, List<String>>> childNodesToMapofMap(NodeList result) {
        HashMap v = Maps.newHashMap();
        for (int i = 0; i < result.getLength(); ++i) {
            Map<String, List<Node>> keyValue = this.childNodesToNodeMap(result.item(i));
            AbstractLargeRestfulTests.assertEquals((int)2, (int)keyValue.size());
            AbstractLargeRestfulTests.assertTrue((boolean)keyValue.containsKey("key"));
            AbstractLargeRestfulTests.assertTrue((boolean)keyValue.containsKey("value"));
            Node valueNode = keyValue.get("value").get(0);
            Node key = keyValue.get("key").get(0);
            NodeList entryList = valueNode.getChildNodes();
            HashMap pv = Maps.newHashMap();
            v.put(key.getTextContent(), pv);
            for (int j = 0; j < entryList.getLength(); ++j) {
                Node n = entryList.item(j);
                if (!"entry".equals(n.getNodeName())) continue;
                Map<String, List<String>> ve = this.childNodesToMap(entryList.item(j));
                AbstractLargeRestfulTests.assertTrue((boolean)ve.containsKey("key"));
                List l = (List)pv.get(ve.get("key").get(0));
                if (l == null) {
                    l = Lists.newArrayList();
                    pv.put(ve.get("key").get(0), l);
                }
                l.add(ve.get("value").get(0));
            }
        }
        return v;
    }

    protected Map<String, List<Node>> childNodesToNodeMap(Node n) {
        HashMap v = Maps.newHashMap();
        NodeList result = n.getChildNodes();
        for (int i = 0; i < result.getLength(); ++i) {
            Node nv = result.item(i);
            if (nv.getNodeType() != 1) continue;
            List l = (List)v.get(nv.getLocalName());
            if (l == null) {
                l = Lists.newArrayList();
                v.put(nv.getLocalName(), l);
            }
            l.add(nv);
        }
        return v;
    }
}

