/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.core.util.JsonContainerConf;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.service.PersonHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.classextension.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonHandlerTest
extends EasyMockTestCase {
    private PersonService personService;
    private PersonHandler handler;
    private FakeGadgetToken token;
    private RestfulRequestItem request;
    private static final Set<String> DEFAULT_FIELDS = Sets.newHashSet((Object[])new String[]{Person.Field.ID.toString(), Person.Field.NAME.toString(), Person.Field.THUMBNAIL_URL.toString()});
    private static final Set<UserId> JOHN_DOE = Sets.newHashSet((Object[])new UserId[]{new UserId(UserId.Type.userId, "john.doe")});
    private static CollectionOptions DEFAULT_OPTIONS = new CollectionOptions();

    protected void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.personService = (PersonService)EasyMock.createMock(PersonService.class);
        JsonContainerConf containerConf = new JsonContainerConf();
        this.handler = new PersonHandler(this.personService, (ContainerConf)containerConf);
    }

    @Override
    protected void replay() {
        EasyMock.replay((Object[])new Object[]{this.personService});
    }

    @Override
    protected void verify() {
        EasyMock.verify((Object[])new Object[]{this.personService});
    }

    private void setPath(String path) {
        HashMap params = Maps.newHashMap();
        params.put("sortBy", null);
        params.put("sortOrder", null);
        params.put("filterBy", null);
        params.put("startIndex", null);
        params.put("count", null);
        params.put("fields", null);
        this.setPathAndParams(path, params);
    }

    private void setPathAndParams(String path, Map<String, String> params) {
        this.request = new RestfulRequestItem(path, "GET", null, (SecurityToken)this.token, null);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.request.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public void testHandleGetAllNoParams() throws Exception {
        this.setPath("/people/john.doe/@all");
        ImmutableList personList = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)personList);
        EasyMock.expect((Object)this.personService.getPeople(JOHN_DOE, new GroupId(GroupId.Type.all, null), DEFAULT_OPTIONS, DEFAULT_FIELDS, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetFriendsNoParams() throws Exception {
        this.setPath("/people/john.doe/@friends");
        ImmutableList personList = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)personList);
        EasyMock.expect((Object)this.personService.getPeople(JOHN_DOE, new GroupId(GroupId.Type.friends, null), DEFAULT_OPTIONS, DEFAULT_FIELDS, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetFriendsWithParams() throws Exception {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy(Person.Field.NAME.toString());
        options.setSortOrder(PersonService.SortOrder.descending);
        options.setFilter("topFriends");
        options.setFilterOperation(PersonService.FilterOperation.present);
        options.setFilterValue("cassie");
        options.setFirst(5);
        options.setMax(10);
        HashMap params = Maps.newHashMap();
        params.put("sortBy", options.getSortBy());
        params.put("sortOrder", options.getSortOrder().toString());
        params.put("filterBy", options.getFilter());
        params.put("filterOp", options.getFilterOperation().toString());
        params.put("filterValue", options.getFilterValue());
        params.put("startIndex", "5");
        params.put("count", "10");
        params.put("fields", "money,fame,fortune");
        this.setPathAndParams("/people/john.doe/@friends", params);
        ImmutableList people = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)people);
        EasyMock.expect((Object)this.personService.getPeople(JOHN_DOE, new GroupId(GroupId.Type.friends, null), options, (Set)ImmutableSortedSet.of((Comparable[])new String[]{"money", "fame", "fortune"}), (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetFriendById() throws Exception {
        this.setPath("/people/john.doe/@friends/jane.doe");
        PersonImpl data = new PersonImpl();
        EasyMock.expect((Object)this.personService.getPerson(new UserId(UserId.Type.userId, "jane.doe"), DEFAULT_FIELDS, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetSelf() throws Exception {
        this.setPath("/people/john.doe/@self");
        PersonImpl data = new PersonImpl();
        EasyMock.expect((Object)this.personService.getPerson(JOHN_DOE.iterator().next(), DEFAULT_FIELDS, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleGetPlural() throws Exception {
        this.setPath("/people/john.doe,jane.doe/@self");
        ImmutableList people = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)people);
        LinkedHashSet userIdSet = Sets.newLinkedHashSet(JOHN_DOE);
        userIdSet.add(new UserId(UserId.Type.userId, "jane.doe"));
        EasyMock.expect((Object)this.personService.getPeople((Set)userIdSet, new GroupId(GroupId.Type.self, null), DEFAULT_OPTIONS, DEFAULT_FIELDS, (SecurityToken)this.token)).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        PersonHandlerTest.assertEquals((Object)data, this.handler.handleGet((RequestItem)this.request).get());
        this.verify();
    }

    public void testHandleDelete() throws Exception {
        this.replay();
        try {
            this.handler.handleDelete((RequestItem)this.request);
            PersonHandlerTest.fail();
        }
        catch (SocialSpiException spe) {
            PersonHandlerTest.assertEquals((Object)ResponseError.BAD_REQUEST, (Object)spe.getError());
        }
        this.verify();
    }

    public void testHandlePut() throws Exception {
        this.replay();
        try {
            this.handler.handlePut((RequestItem)this.request).get();
            PersonHandlerTest.fail();
        }
        catch (SocialSpiException spe) {
            PersonHandlerTest.assertEquals((Object)ResponseError.NOT_IMPLEMENTED, (Object)spe.getError());
        }
        this.verify();
    }

    public void testHandlePost() throws Exception {
        this.replay();
        try {
            this.handler.handlePost((RequestItem)this.request).get();
            PersonHandlerTest.fail();
        }
        catch (SocialSpiException spe) {
            PersonHandlerTest.assertEquals((Object)ResponseError.NOT_IMPLEMENTED, (Object)spe.getError());
        }
        this.verify();
    }

    static {
        DEFAULT_OPTIONS.setSortBy("topFriends");
        DEFAULT_OPTIONS.setSortOrder(PersonService.SortOrder.ascending);
        DEFAULT_OPTIONS.setFilter(null);
        DEFAULT_OPTIONS.setFilterOperation(PersonService.FilterOperation.contains);
        DEFAULT_OPTIONS.setFilterValue("");
        DEFAULT_OPTIONS.setFirst(0);
        DEFAULT_OPTIONS.setMax(20);
    }
}

