/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.social.EasyMockTestCase;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.classextension.EasyMock;

public class RestfulRequestItemTest
extends EasyMockTestCase {
    private static final FakeGadgetToken FAKE_TOKEN = new FakeGadgetToken();
    private static final String DEFAULT_PATH = "/people/john.doe/@self";
    private RestfulRequestItem request;

    protected void setUp() throws Exception {
        super.setUp();
        this.request = new RestfulRequestItem("/people/john.doe/@self?fields=huey,dewey,louie", "GET", "{name: 'Bob', id: '1234'}", (SecurityToken)FAKE_TOKEN, (BeanConverter)new BeanJsonConverter(Guice.createInjector((Module[])new Module[0])));
    }

    public void testParseUrl() throws Exception {
        RestfulRequestItemTest.assertEquals((String)"people", (String)this.request.getService());
        RestfulRequestItemTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"huey", "dewey", "louie"}), (Object)this.request.getListParameter("fields"));
        this.request = new RestfulRequestItem(DEFAULT_PATH, "GET", null, null, null);
        RestfulRequestItemTest.assertEquals((String)"people", (String)this.request.getService());
        RestfulRequestItemTest.assertEquals(null, this.request.getParameters().get("fields"));
    }

    public void testGetHttpMethodFromParameter() throws Exception {
        HttpServletRequest overridden = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)overridden.getParameter("X-HTTP-Method-Override")).andReturn((Object)"DELETE");
        EasyMock.replay((Object[])new Object[]{overridden});
        RestfulRequestItemTest.assertEquals((String)"DELETE", (String)RestfulRequestItem.getMethod((HttpServletRequest)overridden));
        EasyMock.verify((Object[])new Object[]{overridden});
    }

    public void testGetAppId() throws Exception {
        this.request.setParameter("appId", "100");
        RestfulRequestItemTest.assertEquals((String)"100", (String)this.request.getAppId());
        this.request.setParameter("appId", "@app");
        RestfulRequestItemTest.assertEquals((String)FAKE_TOKEN.getAppId(), (String)this.request.getAppId());
    }

    public void testGetUser() throws Exception {
        this.request.setParameter("userId", "@owner");
        RestfulRequestItemTest.assertEquals((Object)UserId.Type.owner, (Object)((UserId)this.request.getUsers().iterator().next()).getType());
    }

    public void testGetGroup() throws Exception {
        this.request.setParameter("groupId", "@self");
        RestfulRequestItemTest.assertEquals((Object)GroupId.Type.self, (Object)this.request.getGroup().getType());
    }

    public void testStartIndex() throws Exception {
        this.request.setParameter("startIndex", null);
        RestfulRequestItemTest.assertEquals((int)0, (int)this.request.getStartIndex());
        this.request.setParameter("startIndex", "5");
        RestfulRequestItemTest.assertEquals((int)5, (int)this.request.getStartIndex());
    }

    public void testCount() throws Exception {
        this.request.setParameter("count", null);
        RestfulRequestItemTest.assertEquals((int)20, (int)this.request.getCount());
        this.request.setParameter("count", "5");
        RestfulRequestItemTest.assertEquals((int)5, (int)this.request.getCount());
    }

    public void testSortOrder() throws Exception {
        this.request.setParameter("sortOrder", null);
        RestfulRequestItemTest.assertEquals((Object)PersonService.SortOrder.ascending, (Object)this.request.getSortOrder());
        this.request.setParameter("sortOrder", "descending");
        RestfulRequestItemTest.assertEquals((Object)PersonService.SortOrder.descending, (Object)this.request.getSortOrder());
    }

    public void testFields() throws Exception {
        this.request.setListParameter("fields", Collections.emptyList());
        RestfulRequestItemTest.assertEquals((Object)Sets.newHashSet(), (Object)this.request.getFields());
        this.request.setParameter("fields", "happy,sad,grumpy");
        RestfulRequestItemTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"happy", "sad", "grumpy"}), (Object)this.request.getFields());
    }

    public void testRouteFromParameter() throws Exception {
        RestfulRequestItemTest.assertEquals((String)"path", (String)RestfulRequestItem.getServiceFromPath((String)"/path"));
        RestfulRequestItemTest.assertEquals((String)"path", (String)RestfulRequestItem.getServiceFromPath((String)"/path/fun"));
        RestfulRequestItemTest.assertEquals((String)"path", (String)RestfulRequestItem.getServiceFromPath((String)"/path/fun/yes"));
    }

    public void testGetTypedParameter() throws Exception {
        InputData input = (InputData)this.request.getTypedParameter("anykey", InputData.class);
        RestfulRequestItemTest.assertEquals((String)"Bob", (String)input.name);
        RestfulRequestItemTest.assertEquals((int)1234, (int)input.id);
    }

    public void testGetTypedParameters() throws Exception {
        InputData input = (InputData)this.request.getTypedParameters(InputData.class);
        RestfulRequestItemTest.assertEquals((String)"Bob", (String)input.name);
        RestfulRequestItemTest.assertEquals((int)1234, (int)input.id);
    }

    public static class InputData {
        String name;
        int id;

        public void setName(String name) {
            this.name = name;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

