/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.social.opensocial.util.ApiValidatorExpcetion;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiValidator {
    private static final Log log = LogFactory.getLog(ApiValidator.class);
    private Context ctx = Context.enter();
    private ScriptableObject scope = this.ctx.initStandardObjects();

    private ApiValidator(String feature) throws IOException, ParserConfigurationException, SAXException {
        this.load(feature);
    }

    public ApiValidator() throws IOException {
    }

    public Map<String, Object> validate(String json, String object, String[] optionalFields, String[] nullfields) throws ApiValidatorExpcetion {
        log.debug((Object)("Loading " + json));
        json = json.trim();
        if (!json.endsWith("}")) {
            json = json + "}";
        }
        if (!json.startsWith("{")) {
            json = "{" + json;
        }
        json = "( testingObject = " + json + " )";
        Object so = null;
        try {
            so = this.ctx.evaluateString((Scriptable)this.scope, json, "test json", 0, null);
        }
        catch (EvaluatorException ex) {
            log.error((Object)("Non parseable JSON " + json));
        }
        log.debug((Object)("Loaded " + so));
        ScriptableObject specification = this.getScriptableObject(object);
        log.debug((Object)("Looking for  " + object + " found " + specification));
        this.listScriptable(object, specification);
        Object[] fields = specification.getIds();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Object fieldName = specification.get(String.valueOf(fields[i]), (Scriptable)specification);
            fieldNames[i] = String.valueOf(fieldName);
        }
        return this.validateObject(so, fieldNames, optionalFields, nullfields);
    }

    public Map<String, Object> validate(String json, String[] fieldNames, String[] optionalFields, String[] nullfields) throws ApiValidatorExpcetion {
        log.debug((Object)("Loading " + json));
        json = json.trim();
        if (!json.endsWith("}")) {
            json = json + "}";
        }
        if (!json.startsWith("{")) {
            json = "{" + json;
        }
        json = "( testingObject = " + json + " )";
        Object so = null;
        try {
            so = this.ctx.evaluateString((Scriptable)this.scope, json, "test json", 0, null);
        }
        catch (EvaluatorException ex) {
            log.error((Object)("Non parseable JSON " + json));
        }
        log.debug((Object)("Loaded " + so));
        return this.validateObject(so, fieldNames, optionalFields, nullfields);
    }

    public Map<String, Object> validateObject(Object jsonObject, String[] fieldNames, String[] optionalFields, String[] nullFields) throws ApiValidatorExpcetion {
        HashMap optional = Maps.newHashMap();
        for (String opt : optionalFields) {
            optional.put(opt, opt);
        }
        HashMap nullf = Maps.newHashMap();
        for (String nf : nullFields) {
            nullf.put(nf, nf);
        }
        HashMap resultFields = Maps.newHashMap();
        if (jsonObject instanceof ScriptableObject) {
            ScriptableObject parsedJSONObject = (ScriptableObject)jsonObject;
            this.listScriptable("testingObject", parsedJSONObject);
            for (String fieldName : fieldNames) {
                Object o = parsedJSONObject.get(fieldName, (Scriptable)parsedJSONObject);
                if (o == ScriptableObject.NOT_FOUND) {
                    if (optional.containsKey(fieldName)) {
                        log.warn((Object)("Missing Optional Field " + fieldName));
                        continue;
                    }
                    if (nullf.containsKey(fieldName)) continue;
                    log.error((Object)("Missing Field " + fieldName));
                    throw new ApiValidatorExpcetion("Missing Field " + fieldName);
                }
                if (nullf.containsKey(fieldName)) {
                    log.error((Object)"Field should have been null and was not");
                }
                if (o == null) {
                    if (nullf.containsKey(fieldName)) {
                        log.error((Object)("Null Fields has been serialized " + fieldName));
                    }
                    log.debug((Object)("Got a Null object for Field " + fieldName + " on json [[" + jsonObject + "]]"));
                } else {
                    log.debug((Object)("Got JSON Field  Field," + fieldName + " as " + o + " " + o.getClass()));
                }
                resultFields.put(String.valueOf(fieldName), o);
            }
        } else {
            throw new ApiValidatorExpcetion("Parsing JSON resulted in invalid Javascript object, which was " + jsonObject + " JSON was [[" + jsonObject + "]]");
        }
        return resultFields;
    }

    private ScriptableObject getScriptableObject(String object) {
        String[] path = object.split("\\.");
        log.debug((Object)("Looking up " + object + " elements " + path.length));
        ScriptableObject s = this.scope;
        for (String pe : path) {
            log.debug((Object)("Looking up " + pe + " in " + s));
            s = (ScriptableObject)s.get(pe, (Scriptable)s);
            log.debug((Object)("Looking for " + pe + " in found " + s));
        }
        return s;
    }

    private void listScriptable(String id, ScriptableObject scriptableObject) {
        log.debug((Object)("ID is Scriptable " + id));
        if (!id.endsWith("constructor")) {
            Object[] allIDs;
            for (Object oid : allIDs = scriptableObject.getAllIds()) {
                log.debug((Object)(id + "." + oid));
                Object o = scriptableObject.get(String.valueOf(oid), (Scriptable)scriptableObject);
                if (!(o instanceof ScriptableObject)) continue;
                this.listScriptable(id + "." + String.valueOf(oid), (ScriptableObject)o);
            }
        }
    }

    private void load(String spec) throws IOException, SAXException, ParserConfigurationException {
        List<String> scripts = this.getScripts(spec);
        ArrayList compiled = Lists.newArrayList();
        for (String script : scripts) {
            String scriptPath = spec + "/" + script;
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(scriptPath);
            if (in == null && (in = this.getClass().getClassLoader().getResourceAsStream("features/" + scriptPath)) == null) {
                throw new IOException("Cant load spec " + spec + " or features/" + spec + " from classpath");
            }
            InputStreamReader reader = new InputStreamReader(in);
            Script compiledScript = this.ctx.compileReader((Reader)reader, spec, 0, null);
            compiled.add(compiledScript);
        }
        for (Script compiledScript : compiled) {
            compiledScript.exec(this.ctx, (Scriptable)this.scope);
        }
    }

    public void addScript(String javascript) {
        Script compileScript = this.ctx.compileString(javascript, "AdditionalJS", 0, null);
        compileScript.exec(this.ctx, (Scriptable)this.scope);
    }

    private List<String> getScripts(String spec) throws SAXException, IOException, ParserConfigurationException {
        String features = spec + "/feature.xml";
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(features);
        if (in == null && (in = this.getClass().getClassLoader().getResourceAsStream("features/" + features)) == null) {
            throw new IOException("Cant find " + features + " or features/" + features + " in classpath ");
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(in);
        NodeList nl = doc.getElementsByTagName("script");
        ArrayList scripts = Lists.newArrayList();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node scriptNode = nl.item(i);
            NamedNodeMap attributes = scriptNode.getAttributes();
            Node scriptAttr = attributes.getNamedItem("src");
            String script = scriptAttr.getNodeValue();
            scripts.add(script);
        }
        return scripts;
    }

    public static void dump(Map<?, ?> nameJSON) {
        if (log.isDebugEnabled()) {
            for (Map.Entry<?, ?> entry : nameJSON.entrySet()) {
                Object k = entry.getKey();
                Object o = entry.getValue();
                log.info((Object)("Key [" + k + "] value:[" + (o == null ? "null" : o + ":" + o.getClass()) + "]"));
            }
        }
    }
}

