/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.spi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;

public class JsonDbOpensocialServiceTest
extends TestCase {
    private JsonDbOpensocialService db;
    private static final UserId CANON_USER = new UserId(UserId.Type.userId, "canonical");
    private static final UserId JOHN_DOE = new UserId(UserId.Type.userId, "john.doe");
    private static final UserId JANE_DOE = new UserId(UserId.Type.userId, "jane.doe");
    private static final GroupId SELF_GROUP = new GroupId(GroupId.Type.self, null);
    private static final String APP_ID = "1";
    private static final String CANONICAL_USER_ID = "canonical";
    private SecurityToken token = new FakeGadgetToken();

    protected void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()});
        this.db = (JsonDbOpensocialService)injector.getInstance(JsonDbOpensocialService.class);
    }

    public void testGetPersonDefaultFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, Person.Field.DEFAULT_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no id", (Object)person.getId());
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no name", (Object)person.getName());
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user has no thumbnail", (Object)person.getThumbnailUrl());
    }

    public void testGetPersonAllFields() throws Exception {
        Person person = (Person)this.db.getPerson(CANON_USER, Person.Field.ALL_FIELDS, this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((String)"Canonical user not found", (Object)person);
    }

    public void testGetExpectedFriends() throws Exception {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy("topFriends");
        options.setSortOrder(PersonService.SortOrder.ascending);
        options.setFilter(null);
        options.setFilterOperation(PersonService.FilterOperation.contains);
        options.setFilterValue("");
        options.setFirst(0);
        options.setMax(20);
        RestfulCollection responseItem = (RestfulCollection)this.db.getPeople((Set)Sets.newHashSet((Object[])new UserId[]{CANON_USER}), new GroupId(GroupId.Type.friends, null), options, Collections.emptySet(), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)responseItem);
        JsonDbOpensocialServiceTest.assertEquals((int)responseItem.getTotalResults(), (int)4);
        JsonDbOpensocialServiceTest.assertEquals((String)((Person)responseItem.getEntry().get(0)).getId(), (String)"john.doe");
        JsonDbOpensocialServiceTest.assertEquals((String)((Person)responseItem.getEntry().get(1)).getId(), (String)"jane.doe");
    }

    public void testGetExpectedUsersForPlural() throws Exception {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy("topFriends");
        options.setSortOrder(PersonService.SortOrder.ascending);
        options.setFilter(null);
        options.setFilterOperation(PersonService.FilterOperation.contains);
        options.setFilterValue("");
        options.setFirst(0);
        options.setMax(20);
        RestfulCollection responseItem = (RestfulCollection)this.db.getPeople((Set)ImmutableSortedSet.of((Object[])new UserId[]{JOHN_DOE, JANE_DOE}), new GroupId(GroupId.Type.friends, null), options, Collections.emptySet(), this.token).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)responseItem);
        JsonDbOpensocialServiceTest.assertEquals((int)responseItem.getTotalResults(), (int)4);
        JsonDbOpensocialServiceTest.assertEquals((String)((Person)responseItem.getEntry().get(0)).getId(), (String)"john.doe");
        JsonDbOpensocialServiceTest.assertEquals((String)((Person)responseItem.getEntry().get(1)).getId(), (String)"jane.doe");
    }

    public void testGetExpectedActivities() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivities((Set)Sets.newHashSet((Object[])new UserId[]{CANON_USER}), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertTrue((responseItem.getTotalResults() == 2 ? 1 : 0) != 0);
    }

    public void testGetExpectedActivitiesForPlural() throws Exception {
        RestfulCollection responseItem = (RestfulCollection)this.db.getActivities((Set)Sets.newHashSet((Object[])new UserId[]{CANON_USER, JOHN_DOE}), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertTrue((responseItem.getTotalResults() == 3 ? 1 : 0) != 0);
    }

    public void testGetExpectedActivity() throws Exception {
        Activity activity = (Activity)this.db.getActivity(CANON_USER, SELF_GROUP, APP_ID, (Set)Sets.newHashSet((Object[])new String[]{"appId", "body", "mediaItems"}), APP_ID, (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertNotNull((Object)activity);
        JsonDbOpensocialServiceTest.assertNotNull((Object)activity.getBody());
        JsonDbOpensocialServiceTest.assertNull((Object)activity.getBodyId());
    }

    public void testDeleteExpectedActivity() throws Exception {
        this.db.deleteActivities(CANON_USER, SELF_GROUP, APP_ID, (Set)Sets.newHashSet((Object[])new String[]{APP_ID}), (SecurityToken)new FakeGadgetToken());
        try {
            this.db.getActivity(CANON_USER, SELF_GROUP, APP_ID, (Set)Sets.newHashSet((Object[])new String[]{"appId", "body", "mediaItems"}), APP_ID, (SecurityToken)new FakeGadgetToken()).get();
            JsonDbOpensocialServiceTest.fail();
        }
        catch (SocialSpiException sse) {
            JsonDbOpensocialServiceTest.assertEquals((Object)ResponseError.BAD_REQUEST, (Object)sse.getError());
        }
    }

    public void testGetExpectedAppData() throws Exception {
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)Sets.newHashSet((Object[])new UserId[]{CANON_USER}), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertTrue((((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size() == 2 ? 1 : 0) != 0);
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
    }

    public void testGetExpectedAppDataForPlural() throws Exception {
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)Sets.newHashSet((Object[])new UserId[]{CANON_USER, JOHN_DOE}), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertTrue((((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size() == 2 ? 1 : 0) != 0);
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).isEmpty());
        JsonDbOpensocialServiceTest.assertTrue((((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).size() == 1 ? 1 : 0) != 0);
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(JOHN_DOE.getUserId())).containsKey("count"));
    }

    public void testDeleteExpectedAppData() throws Exception {
        this.db.deletePersonData(CANON_USER, SELF_GROUP, APP_ID, (Set)Sets.newHashSet((Object[])new String[]{"count"}), (SecurityToken)new FakeGadgetToken());
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)Sets.newHashSet((Object[])new UserId[]{CANON_USER}), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertTrue((((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size() == 1 ? 1 : 0) != 0);
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("size"));
    }

    public void testUpdateExpectedAppData() throws Exception {
        this.db.updatePersonData(CANON_USER, SELF_GROUP, APP_ID, null, (Map)ImmutableMap.of((Object)"count", (Object)"10", (Object)"newvalue", (Object)"20"), (SecurityToken)new FakeGadgetToken());
        DataCollection responseItem = (DataCollection)this.db.getPersonData((Set)Sets.newHashSet((Object[])new UserId[]{CANON_USER}), SELF_GROUP, APP_ID, Collections.emptySet(), (SecurityToken)new FakeGadgetToken()).get();
        JsonDbOpensocialServiceTest.assertFalse((boolean)responseItem.getEntry().isEmpty());
        JsonDbOpensocialServiceTest.assertFalse((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).isEmpty());
        JsonDbOpensocialServiceTest.assertTrue((((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).size() == 3 ? 1 : 0) != 0);
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("count"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((String)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).get("count")).equals("10"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).containsKey("newvalue"));
        JsonDbOpensocialServiceTest.assertTrue((boolean)((String)((Map)responseItem.getEntry().get(CANONICAL_USER_ID)).get("newvalue")).equals("20"));
    }
}

