/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.config;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.common.servlet.ParameterFetcher;
import org.apache.shindig.social.core.oauth.AuthenticationHandlerProvider;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.core.util.BeanXStreamAtomConverter;
import org.apache.shindig.social.core.util.BeanXStreamConverter;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.core.util.JsonContainerConf;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.DataServiceServletFetcher;
import org.apache.shindig.social.opensocial.service.HandlerDispatcher;
import org.apache.shindig.social.opensocial.service.StandardHandlerDispatcher;
import org.apache.shindig.social.sample.service.SampleContainerHandler;

public class SocialApiGuiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(HandlerDispatcher.class).toProvider(HandlerDispatcherProvider.class);
        this.bind(ParameterFetcher.class).annotatedWith((Annotation)Names.named((String)"DataServiceServlet")).to(DataServiceServletFetcher.class);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.canonical.json.db")).toInstance((Object)"sampledata/canonicaldb.json");
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"shindig.allowUnauthenticated")).toInstance((Object)Boolean.TRUE);
        this.bind(BeanConverter.class).annotatedWith((Annotation)Names.named((String)"shindig.bean.converter.xml")).to(BeanXStreamConverter.class);
        this.bind(BeanConverter.class).annotatedWith((Annotation)Names.named((String)"shindig.bean.converter.json")).to(BeanJsonConverter.class);
        this.bind(BeanConverter.class).annotatedWith((Annotation)Names.named((String)"shindig.bean.converter.atom")).to(BeanXStreamAtomConverter.class);
        this.bind((TypeLiteral)new TypeLiteral<List<AuthenticationHandler>>(){}).toProvider(AuthenticationHandlerProvider.class);
        this.bind(ContainerConf.class).to(JsonContainerConf.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HandlerDispatcherProvider
    implements Provider<HandlerDispatcher> {
        private final HandlerDispatcher dispatcher;

        @Inject
        public HandlerDispatcherProvider(StandardHandlerDispatcher dispatcher, Provider<SampleContainerHandler> sampleHandler) {
            dispatcher.addHandler("samplecontainer", sampleHandler);
            this.dispatcher = dispatcher;
        }

        public HandlerDispatcher get() {
            return this.dispatcher;
        }
    }
}

