/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shindig.social.core.model.EnumImpl;
import org.apache.shindig.social.opensocial.model.Enum;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanJsonConverter
implements BeanConverter {
    private static final Object[] EMPTY_OBJECT = new Object[0];
    private static final Set<String> EXCLUDED_FIELDS = ImmutableSet.of((Object[])new String[]{"class", "declaringclass"});
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final ConcurrentHashMap<Class, List<MethodPair>> GETTER_METHODS = Maps.newConcurrentHashMap();
    private static final ConcurrentHashMap<Class, List<MethodPair>> SETTER_METHODS = Maps.newConcurrentHashMap();
    private Injector injector;

    @Inject
    public BeanJsonConverter(Injector injector) {
        this.injector = injector;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String convertToString(Object pojo) {
        return this.convertToJson(pojo).toString();
    }

    public Object convertToJson(Object pojo) {
        try {
            return this.translateObjectToJson(pojo);
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not translate " + pojo + " to json", e);
        }
    }

    private Object translateObjectToJson(Object val) throws JSONException {
        if (val instanceof Object[]) {
            JSONArray array = new JSONArray();
            for (Object asd : (Object[])val) {
                array.put(this.translateObjectToJson(asd));
            }
            return array;
        }
        if (val instanceof List) {
            JSONArray list = new JSONArray();
            for (Object item : (List)val) {
                list.put(this.translateObjectToJson(item));
            }
            return list;
        }
        if (val instanceof Map) {
            JSONObject map = new JSONObject();
            Map originalMap = (Map)val;
            for (Map.Entry item : originalMap.entrySet()) {
                map.put(item.getKey().toString(), this.translateObjectToJson(item.getValue()));
            }
            return map;
        }
        if (val != null && val.getClass().isEnum()) {
            return val.toString();
        }
        if (val instanceof String || val instanceof Boolean || val instanceof Integer || val instanceof Date || val instanceof Long || val instanceof Float || val instanceof JSONObject || val instanceof JSONArray || val == null) {
            return val;
        }
        return this.convertMethodsToJson(val);
    }

    private JSONObject convertMethodsToJson(Object pojo) {
        List<MethodPair> availableGetters = GETTER_METHODS.get(pojo.getClass());
        if (availableGetters == null) {
            availableGetters = this.getMatchingMethods(pojo, GETTER_PREFIX, false);
            GETTER_METHODS.putIfAbsent(pojo.getClass(), availableGetters);
        }
        JSONObject toReturn = new JSONObject();
        for (MethodPair getter : availableGetters) {
            String errorMessage = "Could not encode the " + getter.method + " method on " + pojo.getClass().getName();
            try {
                Object val = getter.method.invoke(pojo, EMPTY_OBJECT);
                if (val == null) continue;
                toReturn.put(getter.fieldName, this.translateObjectToJson(val));
            }
            catch (JSONException e) {
                throw new RuntimeException(errorMessage, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(errorMessage, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(errorMessage, e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(errorMessage, e);
            }
        }
        return toReturn;
    }

    private List<MethodPair> getMatchingMethods(Object pojo, String prefix, boolean allowHaveArgs) {
        Method[] methods;
        ArrayList availableGetters = Lists.newArrayList();
        for (Method method : methods = pojo.getClass().getMethods()) {
            int prefixlen;
            String fieldName;
            String name = method.getName();
            if (!method.getName().startsWith(prefix) || EXCLUDED_FIELDS.contains((fieldName = name.substring(prefixlen = prefix.length(), prefixlen + 1).toLowerCase() + name.substring(prefixlen + 1)).toLowerCase()) || !allowHaveArgs && method.getParameterTypes().length != 0) continue;
            availableGetters.add(new MethodPair(method, fieldName));
        }
        return availableGetters;
    }

    @Override
    public <T> T convertToObject(String json, Class<T> className) {
        String errorMessage = "Could not convert " + json + " to " + className;
        try {
            Object pojo = this.injector.getInstance(className);
            return (T)this.convertToObject(json, pojo);
        }
        catch (JSONException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    private <T> T convertToObject(String json, T pojo) throws JSONException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        if (pojo instanceof String) {
            pojo = json;
        } else if (pojo instanceof Map) {
            Class<String> mapValueClass = String.class;
            JSONObject jsonObject = new JSONObject(json);
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Class<String> value = this.convertToObject(jsonObject.getString(key), (T)mapValueClass);
                ((Map)pojo).put(key, value);
            }
        } else if (pojo instanceof List) {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                ((List)pojo).add(array.get(i));
            }
        } else {
            JSONObject jsonObject = new JSONObject(json);
            List<MethodPair> methods = SETTER_METHODS.get(pojo.getClass());
            if (methods == null) {
                methods = this.getMatchingMethods(pojo, SETTER_PREFIX, true);
                SETTER_METHODS.putIfAbsent(pojo.getClass(), methods);
            }
            for (MethodPair setter : methods) {
                if (!jsonObject.has(setter.fieldName)) continue;
                this.callSetterWithValue(pojo, setter.method, jsonObject, setter.fieldName);
            }
        }
        return (T)pojo;
    }

    private <T> void callSetterWithValue(T pojo, Method method, JSONObject jsonObject, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException, JSONException {
        Class<?> expectedType = method.getParameterTypes()[0];
        Class<?> value = null;
        if (jsonObject.has(fieldName)) {
            if (expectedType.equals(List.class)) {
                Class rawType;
                Class listElementClass;
                ParameterizedType genericListType = (ParameterizedType)method.getGenericParameterTypes()[0];
                Type type = genericListType.getActualTypeArguments()[0];
                if (type instanceof ParameterizedType) {
                    listElementClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                    rawType = (Class)((ParameterizedType)type).getRawType();
                } else {
                    rawType = listElementClass = (Class)type;
                }
                ArrayList list = Lists.newArrayList();
                JSONArray jsonArray = jsonObject.getJSONArray(fieldName);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    if (Enum.class.isAssignableFrom(rawType)) {
                        list.add(this.convertEnum(listElementClass, jsonArray.getJSONObject(i)));
                        continue;
                    }
                    list.add(this.convertToObject(jsonArray.getString(i), (T)listElementClass));
                }
                value = list;
            } else if (expectedType.equals(Map.class)) {
                ParameterizedType genericListType = (ParameterizedType)method.getGenericParameterTypes()[0];
                Type[] types = genericListType.getActualTypeArguments();
                Class valueClass = (Class)types[1];
                HashMap map = Maps.newHashMap();
                JSONObject jsonMap = jsonObject.getJSONObject(fieldName);
                Iterator keys = jsonMap.keys();
                while (keys.hasNext()) {
                    String keyName = (String)keys.next();
                    map.put(keyName, this.convertToObject(jsonMap.getString(keyName), (T)valueClass));
                }
                value = map;
            } else if (Enum.class.isAssignableFrom(expectedType)) {
                value = this.convertEnum((Class)((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0], jsonObject.getJSONObject(fieldName));
            } else if (expectedType.isEnum()) {
                if (jsonObject.has(fieldName)) {
                    for (Object v : expectedType.getEnumConstants()) {
                        if (!v.toString().equals(jsonObject.getString(fieldName))) continue;
                        value = v;
                        break;
                    }
                    if (value == null) {
                        throw new IllegalArgumentException("No enum value  '" + jsonObject.getString(fieldName) + "' in " + expectedType.getName());
                    }
                }
            } else if (expectedType.equals(String.class)) {
                value = jsonObject.getString(fieldName);
            } else if (expectedType.equals(Date.class)) {
                value = new DateTime((Object)jsonObject.getString(fieldName)).toDate();
            } else if (expectedType.equals(Long.class) || expectedType.equals(Long.TYPE)) {
                value = jsonObject.getLong(fieldName);
            } else if (expectedType.equals(Integer.class) || expectedType.equals(Integer.TYPE)) {
                value = jsonObject.getInt(fieldName);
            } else if (expectedType.equals(Boolean.class) || expectedType.equals(Boolean.TYPE)) {
                value = jsonObject.getBoolean(fieldName);
            } else if (expectedType.equals(Float.class) || expectedType.equals(Float.TYPE)) {
                String stringFloat = jsonObject.getString(fieldName);
                value = new Float(stringFloat);
            } else {
                value = this.convertToObject(jsonObject.getJSONObject(fieldName).toString(), (T)expectedType);
            }
        }
        if (value != null) {
            method.invoke(pojo, value);
        }
    }

    private Object convertEnum(Class<?> enumKeyType, JSONObject jsonEnum) throws JSONException, IllegalAccessException, NoSuchFieldException {
        EnumImpl<Object> value;
        if (jsonEnum.has(Enum.Field.VALUE.toString())) {
            Enum.EnumKey enumKey = (Enum.EnumKey)enumKeyType.getField(jsonEnum.getString(Enum.Field.VALUE.toString())).get(null);
            value = new EnumImpl<Enum.EnumKey>(enumKey, jsonEnum.getString(Enum.Field.DISPLAY_VALUE.toString()));
        } else {
            value = new EnumImpl<Object>(null, jsonEnum.getString(Enum.Field.DISPLAY_VALUE.toString()));
        }
        return value;
    }

    private static class MethodPair {
        public Method method;
        public String fieldName;

        private MethodPair(Method method, String fieldName) {
            this.method = method;
            this.fieldName = fieldName;
        }
    }
}

