/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import junit.framework.TestCase;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.social.opensocial.spi.UserId;

public class UserIdTest
extends TestCase {
    public void testGetUserId() throws Exception {
        UserId owner = new UserId(UserId.Type.owner, "hello");
        UserIdTest.assertEquals((String)"owner", (String)owner.getUserId((SecurityToken)new FakeGadgetToken().setOwnerId("owner")));
        UserId viewer = new UserId(UserId.Type.viewer, "hello");
        UserIdTest.assertEquals((String)"viewer", (String)viewer.getUserId((SecurityToken)new FakeGadgetToken().setViewerId("viewer")));
        UserId me = new UserId(UserId.Type.me, "hello");
        UserIdTest.assertEquals((String)"viewer", (String)me.getUserId((SecurityToken)new FakeGadgetToken().setViewerId("viewer")));
        UserId user = new UserId(UserId.Type.userId, "hello");
        UserIdTest.assertEquals((String)"hello", (String)user.getUserId((SecurityToken)new FakeGadgetToken()));
    }

    public void testFromJson() throws Exception {
        UserId owner = UserId.fromJson((String)"@owner");
        UserIdTest.assertEquals((Object)UserId.Type.owner, (Object)owner.getType());
        UserId viewer = UserId.fromJson((String)"@viewer");
        UserIdTest.assertEquals((Object)UserId.Type.viewer, (Object)viewer.getType());
        UserId me = UserId.fromJson((String)"@me");
        UserIdTest.assertEquals((Object)UserId.Type.me, (Object)me.getType());
        UserId user = UserId.fromJson((String)"john.doe");
        UserIdTest.assertEquals((Object)UserId.Type.userId, (Object)user.getType());
        UserIdTest.assertEquals((String)"john.doe", (String)user.getUserId());
    }
}

