/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.social.JsonLibTestsGuiceModule;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.util.BeanJsonLibConversionException;
import org.apache.shindig.social.core.util.BeanJsonLibConverter;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.util.ApiValidator;
import org.apache.shindig.social.opensocial.util.ApiValidatorExpcetion;

public class BeanJsonLibConverterTest
extends TestCase {
    private static final Log log = LogFactory.getLog(BeanJsonLibConverterTest.class);
    private static final String[] PERSON_FIELDS = new String[]{"id", "name", "nickname", "thumbnailUrl", "profileUrl", "currentLocation", "addresses", "emails", "phoneNumbers", "aboutMe", "status", "profileSong", "profileVideo", "gender", "sexualOrientation", "relationshipStatus", "age", "dateOfBirth", "bodyType", "ethnicity", "smoker", "drinker", "children", "pets", "livingArrangement", "timeZone", "languagesSpoken", "jobs", "jobInterests", "schools", "interests", "urls", "music", "movies", "tvShows", "books", "activities", "sports", "heroes", "quotes", "cars", "food", "turnOns", "turnOffs", "tags", "romance", "scaredOf", "happiestWhen", "fashion", "humor", "lookingFor", "religion", "politicalViews", "hasApp", "networkPresence"};
    private static final String[] NAME_FIELDS = new String[]{"familyName", "givenName", "additionalName", "honorificPrefix", "honorificSuffix", "formatted"};
    private Person johnDoe;
    private Activity activity;
    private BeanJsonLibConverter beanJsonConverter;
    private ApiValidator apiValidator;
    private boolean outputInfo = false;

    public void setUp() throws Exception {
        super.setUp();
        this.johnDoe = new PersonImpl("johnDoeId", "Johnny", (Name)new NameImpl("John Doe"));
        this.johnDoe.setPhoneNumbers((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("home", "+33H000000000"), new ListFieldImpl("mobile", "+33M000000000"), new ListFieldImpl("work", "+33W000000000")}));
        this.johnDoe.setAddresses((List)Lists.newArrayList((Object[])new Address[]{new AddressImpl("My home address")}));
        this.johnDoe.setEmails((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("work", "john.doe@work.bar"), new ListFieldImpl("home", "john.doe@home.bar")}));
        this.activity = new ActivityImpl("activityId", this.johnDoe.getId());
        this.activity.setMediaItems((List)Lists.newArrayList((Object[])new MediaItem[]{new MediaItemImpl("image/jpg", MediaItem.Type.IMAGE, "http://foo.bar")}));
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonLibTestsGuiceModule()});
        this.beanJsonConverter = (BeanJsonLibConverter)injector.getInstance(BeanJsonLibConverter.class);
        this.apiValidator = new ApiValidator();
    }

    public void testToJsonOnInheritedClass() throws Exception {
        SpecialPerson cassie = new SpecialPerson("5", "robot", "nonsense");
        String result = this.beanJsonConverter.convertToString((Object)cassie);
        this.validatePerson(result, "5", "robot", SpecialPerson.OPTIONALFIELDS, SpecialPerson.NULLFIELDS);
        String[] optional = new String[]{};
        String[] nullfields = new String[]{};
        Map<String, Object> special = this.apiValidator.validate(result, new String[]{"newfield"}, optional, nullfields);
        BeanJsonLibConverterTest.assertNotNull((Object)special.get("newfield"));
        BeanJsonLibConverterTest.assertEquals(String.class, special.get("newfield").getClass());
        BeanJsonLibConverterTest.assertEquals((Object)"nonsense", (Object)special.get("newfield"));
        SpecialPerson parseCassie = (SpecialPerson)((Object)this.beanJsonConverter.convertToObject(result, SpecialPerson.class));
        BeanJsonLibConverterTest.assertNotNull((Object)((Object)parseCassie));
        BeanJsonLibConverterTest.assertEquals((String)cassie.getId(), (String)parseCassie.getId());
        BeanJsonLibConverterTest.assertEquals((String)cassie.getNewfield(), (String)parseCassie.getNewfield());
        Name name = parseCassie.getName();
        Name cassieName = cassie.getName();
        BeanJsonLibConverterTest.assertNotNull((Object)name);
        BeanJsonLibConverterTest.assertEquals((String)cassieName.getFormatted(), (String)name.getFormatted());
        BeanJsonLibConverterTest.assertEquals((String)cassieName.getAdditionalName(), (String)name.getAdditionalName());
        BeanJsonLibConverterTest.assertEquals((String)cassieName.getFamilyName(), (String)name.getFamilyName());
        BeanJsonLibConverterTest.assertEquals((String)cassieName.getGivenName(), (String)name.getGivenName());
        BeanJsonLibConverterTest.assertEquals((String)cassieName.getHonorificPrefix(), (String)name.getHonorificPrefix());
        BeanJsonLibConverterTest.assertEquals((String)cassieName.getHonorificSuffix(), (String)name.getHonorificSuffix());
    }

    private void validatePerson(String result, String id, String name, String[] optional, String[] nullfields) throws ApiValidatorExpcetion {
        Map<String, Object> standard = this.apiValidator.validate(result, PERSON_FIELDS, optional, nullfields);
        BeanJsonLibConverterTest.assertNotNull((Object)standard.get("id"));
        BeanJsonLibConverterTest.assertEquals(String.class, standard.get("id").getClass());
        BeanJsonLibConverterTest.assertEquals((Object)id, (Object)standard.get("id"));
        BeanJsonLibConverterTest.assertNotNull((Object)standard.get("name"));
        Map<String, Object> nameJSON = this.apiValidator.validateObject(standard.get("name"), NAME_FIELDS, optional, nullfields);
        ApiValidator.dump(nameJSON);
        BeanJsonLibConverterTest.assertNotNull((Object)nameJSON.get("formatted"));
        BeanJsonLibConverterTest.assertEquals(String.class, nameJSON.get("formatted").getClass());
        BeanJsonLibConverterTest.assertEquals((Object)name, (Object)nameJSON.get("formatted"));
        BeanJsonLibConverterTest.assertNull((Object)nameJSON.get("additionalName"));
    }

    public void testPersonToJson() throws Exception {
        int i;
        String result = this.beanJsonConverter.convertToString((Object)this.johnDoe);
        if (this.outputInfo) {
            log.info((Object)("JSON (" + result + ")"));
        }
        Person parsedPerson = (Person)this.beanJsonConverter.convertToObject(result, Person.class);
        BeanJsonLibConverterTest.assertEquals((String)this.johnDoe.getId(), (String)parsedPerson.getId());
        BeanJsonLibConverterTest.assertEquals((String)this.johnDoe.getName().getFormatted(), (String)parsedPerson.getName().getFormatted());
        List addresses = parsedPerson.getAddresses();
        if (this.outputInfo) {
            for (Address o : addresses) {
                log.info((Object)("Address " + o));
            }
        }
        BeanJsonLibConverterTest.assertEquals((int)1, (int)addresses.size());
        Address address = (Address)addresses.get(0);
        String formatted = address.getFormatted();
        BeanJsonLibConverterTest.assertNotNull((Object)formatted);
        BeanJsonLibConverterTest.assertEquals((String)((Address)this.johnDoe.getAddresses().get(0)).getFormatted(), (String)((Address)parsedPerson.getAddresses().get(0)).getFormatted());
        BeanJsonLibConverterTest.assertEquals((int)3, (int)parsedPerson.getPhoneNumbers().size());
        for (i = 0; i < this.johnDoe.getPhoneNumbers().size(); ++i) {
            ListField expectedPhone = (ListField)this.johnDoe.getPhoneNumbers().get(i);
            ListField actualPhone = (ListField)parsedPerson.getPhoneNumbers().get(i);
            BeanJsonLibConverterTest.assertEquals((String)expectedPhone.getType(), (String)actualPhone.getType());
            BeanJsonLibConverterTest.assertEquals((String)expectedPhone.getValue(), (String)actualPhone.getValue());
        }
        BeanJsonLibConverterTest.assertEquals((int)2, (int)parsedPerson.getEmails().size());
        for (i = 0; i < this.johnDoe.getEmails().size(); ++i) {
            ListField expectedEmail = (ListField)this.johnDoe.getEmails().get(i);
            ListField actualEmail = (ListField)parsedPerson.getEmails().get(i);
            BeanJsonLibConverterTest.assertEquals((String)expectedEmail.getType(), (String)actualEmail.getType());
            BeanJsonLibConverterTest.assertEquals((String)expectedEmail.getValue(), (String)actualEmail.getValue());
        }
    }

    public void testActivityToJson() throws Exception {
        String result = this.beanJsonConverter.convertToString((Object)this.activity);
        if (this.outputInfo) {
            log.info((Object)("JSON (" + result + ")"));
        }
        Activity parsedActivity = (Activity)this.beanJsonConverter.convertToObject(result, Activity.class);
        BeanJsonLibConverterTest.assertEquals((String)this.activity.getUserId(), (String)parsedActivity.getUserId());
        BeanJsonLibConverterTest.assertEquals((String)this.activity.getId(), (String)parsedActivity.getId());
        BeanJsonLibConverterTest.assertEquals((int)1, (int)parsedActivity.getMediaItems().size());
        MediaItem expectedItem = (MediaItem)this.activity.getMediaItems().get(0);
        MediaItem actualItem = (MediaItem)parsedActivity.getMediaItems().get(0);
        BeanJsonLibConverterTest.assertEquals((String)expectedItem.getUrl(), (String)actualItem.getUrl());
        BeanJsonLibConverterTest.assertEquals((String)expectedItem.getMimeType(), (String)actualItem.getMimeType());
        BeanJsonLibConverterTest.assertEquals((String)expectedItem.getType().toString(), (String)actualItem.getType().toString());
    }

    public void testMapsToJson() throws Exception {
        HashMap map = Maps.newHashMap();
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        item1Map.put("value2", null);
        map.put("item1", item1Map);
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        map.put("item2", item2Map);
        String result = this.beanJsonConverter.convertToString((Object)map);
        if (this.outputInfo) {
            log.info((Object)("JSON (" + result + ")"));
        }
        this.beanJsonConverter.addMapping("item1", Map.class);
        this.beanJsonConverter.addMapping("item2", Map.class);
        Map parsedMap = (Map)this.beanJsonConverter.convertToObject(result, Map.class);
        if (this.outputInfo) {
            log.info((Object)("Dumping Map (" + parsedMap + ")"));
        }
        ApiValidator.dump(parsedMap);
        BeanJsonLibConverterTest.assertEquals((Object)"1", ((Map)parsedMap.get("item1")).get("value"));
        BeanJsonLibConverterTest.assertEquals((Object)"2", ((Map)parsedMap.get("item2")).get("value"));
    }

    public void testListsToJson() throws Exception {
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        ArrayList list = Lists.newArrayList();
        list.add(item1Map);
        list.add(item2Map);
        String result = this.beanJsonConverter.convertToString((Object)list);
        if (this.outputInfo) {
            log.info((Object)("JSON (" + result + ")"));
        }
        Map[] parsedList = (Map[])this.beanJsonConverter.convertToObject(result, Map[].class);
        BeanJsonLibConverterTest.assertEquals((Object)"1", parsedList[0].get("value"));
        BeanJsonLibConverterTest.assertEquals((Object)"2", parsedList[1].get("value"));
    }

    public void testArrayToJson() throws Exception {
        String[] colors = new String[]{"blue", "green", "aquamarine"};
        String result = this.beanJsonConverter.convertToString((Object)colors);
        if (this.outputInfo) {
            log.info((Object)("JSON (" + result + ")"));
        }
        String[] parsedColors = (String[])this.beanJsonConverter.convertToObject(result, String[].class);
        BeanJsonLibConverterTest.assertEquals((int)colors.length, (int)parsedColors.length);
        BeanJsonLibConverterTest.assertEquals((String)colors[0], (String)parsedColors[0]);
        BeanJsonLibConverterTest.assertEquals((String)colors[1], (String)parsedColors[1]);
        BeanJsonLibConverterTest.assertEquals((String)colors[2], (String)parsedColors[2]);
    }

    public void testJsonToActivity() throws Exception {
        String jsonActivity = "{userId : 5, id : 6, mediaItems : [{url : 'hello', mimeType : 'mimey', type : 'VIDEO'}]}";
        Activity result = (Activity)this.beanJsonConverter.convertToObject(jsonActivity, Activity.class);
        BeanJsonLibConverterTest.assertEquals((String)"5", (String)result.getUserId());
        BeanJsonLibConverterTest.assertEquals((String)"6", (String)result.getId());
        BeanJsonLibConverterTest.assertEquals((int)1, (int)result.getMediaItems().size());
        MediaItem actualItem = (MediaItem)result.getMediaItems().get(0);
        BeanJsonLibConverterTest.assertEquals((String)"hello", (String)actualItem.getUrl());
        BeanJsonLibConverterTest.assertEquals((String)"mimey", (String)actualItem.getMimeType());
        BeanJsonLibConverterTest.assertEquals((String)"video", (String)actualItem.getType().toString());
    }

    public void testJsonToMap() throws Exception {
        String jsonActivity = "{count : 0, favoriteColor : 'yellow'}";
        Map data = Maps.newHashMap();
        data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, data.getClass());
        BeanJsonLibConverterTest.assertEquals((int)2, (int)data.size());
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("count")) {
                BeanJsonLibConverterTest.assertEquals((Object)0, value);
                continue;
            }
            if (!key.equals("favoriteColor")) continue;
            BeanJsonLibConverterTest.assertEquals((Object)"yellow", value);
        }
    }

    public void testEmptyObject() {
        BeanJsonLibConverterTest.assertEquals((String)"{}", (String)this.beanJsonConverter.convertToString((Object)""));
        BeanJsonLibConverterTest.assertEquals((int)0, (int)((Map)this.beanJsonConverter.convertToObject("", Map.class)).size());
        BeanJsonLibConverterTest.assertEquals((int)0, (int)((String[])this.beanJsonConverter.convertToObject("[]", String[].class)).length);
        BeanJsonLibConverterTest.assertEquals((int)2, (int)((String[])this.beanJsonConverter.convertToObject("[\"a\",\"b\"]", String[].class)).length);
    }

    public void testException() {
        BeanJsonLibConverterTest.assertNotNull((Object)new BeanJsonLibConversionException());
        BeanJsonLibConverterTest.assertNotNull((Object)new BeanJsonLibConversionException("message"));
        BeanJsonLibConverterTest.assertNotNull((Object)new BeanJsonLibConversionException((Throwable)new Exception()));
        BeanJsonLibConverterTest.assertNotNull((Object)new BeanJsonLibConversionException("message", (Throwable)new Exception()));
    }

    public static class SpecialPerson
    extends PersonImpl {
        public static final String[] OPTIONALFIELDS = new String[0];
        public static final String[] NULLFIELDS = new String[]{"jobInterests", "nickname", "romance", "religion", "timeZone", "relationshipStatus", "tags", "networkPresence", "books", "quotes", "phoneNumbers", "languagesSpoken", "activities", "jobs", "dateOfBirth", "profileVideo", "bodyType", "urls", "schools", "music", "addresses", "livingArrangement", "thumbnailUrl", "humor", "sports", "scaredOf", "movies", "age", "pets", "hasApp", "turnOffs", "gender", "fashion", "drinker", "aboutMe", "children", "sexualOrientation", "heroes", "profileSong", "lookingFor", "cars", "turnOns", "tvShows", "profileUrl", "status", "currentLocation", "smoker", "happiestWhen", "ethnicity", "food", "emails", "politicalViews", "interests", "familyName", "honorificSuffix", "additionalName", "honorificPrefix", "givenName"};
        private String newfield;

        public SpecialPerson() {
        }

        public SpecialPerson(String id, String name, String newfield) {
            super(id, name, (Name)new NameImpl(name));
            this.newfield = newfield;
        }

        public String getNewfield() {
            return this.newfield;
        }

        public void setNewfield(String newfield) {
            this.newfield = newfield;
        }
    }
}

