/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.service;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="samplecontainer", path="/{type}/{doevil}")
public class SampleContainerHandler {
    private final JsonDbOpensocialService service;

    @Inject
    public SampleContainerHandler(JsonDbOpensocialService dbService) {
        this.service = dbService;
    }

    @Operation(httpMethods={"PUT"})
    public Future<?> update(RequestItem request) throws ProtocolException {
        return this.create(request);
    }

    @Operation(httpMethods={"POST"}, bodyParam="data")
    public Future<?> create(RequestItem request) throws ProtocolException {
        String type = request.getParameter("type");
        if (type.equals("setstate")) {
            try {
                Map bodyparams = (Map)request.getTypedParameter("data", Map.class);
                String stateFile = (String)bodyparams.get("fileurl");
                this.service.setDb(new JSONObject(this.fetchStateDocument(stateFile)));
            }
            catch (JSONException e) {
                throw new ProtocolException(400, "The json state file was not valid json", (Throwable)e);
            }
        } else if (type.equals("setevilness")) {
            throw new ProtocolException(501, "evil data has not been implemented yet");
        }
        return ImmediateFuture.newInstance(null);
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(RequestItem request) {
        return ImmediateFuture.newInstance((Object)this.service.getDb());
    }

    private String fetchStateDocument(String stateFileLocation) {
        String errorMessage = "The json state file " + stateFileLocation + " could not be fetched and parsed.";
        GetMethod jsonState = new GetMethod(stateFileLocation);
        HttpClient client = new HttpClient();
        try {
            client.executeMethod((HttpMethod)jsonState);
            if (jsonState.getStatusCode() != 200) {
                throw new RuntimeException(errorMessage);
            }
            String string = jsonState.getResponseBodyAsString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(errorMessage, e);
        }
        finally {
            jsonState.releaseConnection();
        }
    }
}

